package com.google.gerrit.index.query;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QueryResult<T> extends QueryResult<T> {

  @Nullable
  private final String query;

  private final Predicate<T> predicate;

  private final ImmutableList<T> entities;

  private final boolean more;

  AutoValue_QueryResult(
      @Nullable String query,
      Predicate<T> predicate,
      ImmutableList<T> entities,
      boolean more) {
    this.query = query;
    if (predicate == null) {
      throw new NullPointerException("Null predicate");
    }
    this.predicate = predicate;
    if (entities == null) {
      throw new NullPointerException("Null entities");
    }
    this.entities = entities;
    this.more = more;
  }

  @Nullable
  @Override
  public String query() {
    return query;
  }

  @Override
  public Predicate<T> predicate() {
    return predicate;
  }

  @Override
  public ImmutableList<T> entities() {
    return entities;
  }

  @Override
  public boolean more() {
    return more;
  }

  @Override
  public String toString() {
    return "QueryResult{"
        + "query=" + query + ", "
        + "predicate=" + predicate + ", "
        + "entities=" + entities + ", "
        + "more=" + more
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryResult) {
      QueryResult<?> that = (QueryResult<?>) o;
      return (this.query == null ? that.query() == null : this.query.equals(that.query()))
          && this.predicate.equals(that.predicate())
          && this.entities.equals(that.entities())
          && this.more == that.more();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (query == null) ? 0 : query.hashCode();
    h$ *= 1000003;
    h$ ^= predicate.hashCode();
    h$ *= 1000003;
    h$ ^= entities.hashCode();
    h$ *= 1000003;
    h$ ^= more ? 1231 : 1237;
    return h$;
  }

}
