package com.google.gerrit.server;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.entities.Project;
import com.google.gerrit.server.logging.TraceContext;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_RequestInfo extends RequestInfo {

  private final String requestType;

  private final Optional<String> requestUri;

  private final Optional<String> requestQueryString;

  private final ImmutableList<String> headers;

  private final CurrentUser callingUser;

  private final TraceContext traceContext;

  private final Optional<Project.NameKey> project;

  $AutoValue_RequestInfo(
      String requestType,
      Optional<String> requestUri,
      Optional<String> requestQueryString,
      ImmutableList<String> headers,
      CurrentUser callingUser,
      TraceContext traceContext,
      Optional<Project.NameKey> project) {
    if (requestType == null) {
      throw new NullPointerException("Null requestType");
    }
    this.requestType = requestType;
    if (requestUri == null) {
      throw new NullPointerException("Null requestUri");
    }
    this.requestUri = requestUri;
    if (requestQueryString == null) {
      throw new NullPointerException("Null requestQueryString");
    }
    this.requestQueryString = requestQueryString;
    if (headers == null) {
      throw new NullPointerException("Null headers");
    }
    this.headers = headers;
    if (callingUser == null) {
      throw new NullPointerException("Null callingUser");
    }
    this.callingUser = callingUser;
    if (traceContext == null) {
      throw new NullPointerException("Null traceContext");
    }
    this.traceContext = traceContext;
    if (project == null) {
      throw new NullPointerException("Null project");
    }
    this.project = project;
  }

  @Override
  public String requestType() {
    return requestType;
  }

  @Override
  public Optional<String> requestUri() {
    return requestUri;
  }

  @Override
  public Optional<String> requestQueryString() {
    return requestQueryString;
  }

  @Override
  public ImmutableList<String> headers() {
    return headers;
  }

  @Override
  public CurrentUser callingUser() {
    return callingUser;
  }

  @Override
  public TraceContext traceContext() {
    return traceContext;
  }

  @Override
  public Optional<Project.NameKey> project() {
    return project;
  }

  @Override
  public String toString() {
    return "RequestInfo{"
        + "requestType=" + requestType + ", "
        + "requestUri=" + requestUri + ", "
        + "requestQueryString=" + requestQueryString + ", "
        + "headers=" + headers + ", "
        + "callingUser=" + callingUser + ", "
        + "traceContext=" + traceContext + ", "
        + "project=" + project
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RequestInfo) {
      RequestInfo that = (RequestInfo) o;
      return this.requestType.equals(that.requestType())
          && this.requestUri.equals(that.requestUri())
          && this.requestQueryString.equals(that.requestQueryString())
          && this.headers.equals(that.headers())
          && this.callingUser.equals(that.callingUser())
          && this.traceContext.equals(that.traceContext())
          && this.project.equals(that.project());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= requestType.hashCode();
    h$ *= 1000003;
    h$ ^= requestUri.hashCode();
    h$ *= 1000003;
    h$ ^= requestQueryString.hashCode();
    h$ *= 1000003;
    h$ ^= headers.hashCode();
    h$ *= 1000003;
    h$ ^= callingUser.hashCode();
    h$ *= 1000003;
    h$ ^= traceContext.hashCode();
    h$ *= 1000003;
    h$ ^= project.hashCode();
    return h$;
  }

  static class Builder extends RequestInfo.Builder {
    private String requestType;
    private Optional<String> requestUri = Optional.empty();
    private Optional<String> requestQueryString = Optional.empty();
    private ImmutableList.Builder<String> headersBuilder$;
    private ImmutableList<String> headers;
    private CurrentUser callingUser;
    private TraceContext traceContext;
    private Optional<Project.NameKey> project = Optional.empty();
    Builder() {
    }
    @Override
    public RequestInfo.Builder requestType(String requestType) {
      if (requestType == null) {
        throw new NullPointerException("Null requestType");
      }
      this.requestType = requestType;
      return this;
    }
    @Override
    public RequestInfo.Builder requestUri(String requestUri) {
      this.requestUri = Optional.of(requestUri);
      return this;
    }
    @Override
    public RequestInfo.Builder requestQueryString(String requestQueryString) {
      this.requestQueryString = Optional.of(requestQueryString);
      return this;
    }
    @Override
    ImmutableList.Builder<String> headersBuilder() {
      if (headersBuilder$ == null) {
        headersBuilder$ = ImmutableList.builder();
      }
      return headersBuilder$;
    }
    @Override
    public RequestInfo.Builder callingUser(CurrentUser callingUser) {
      if (callingUser == null) {
        throw new NullPointerException("Null callingUser");
      }
      this.callingUser = callingUser;
      return this;
    }
    @Override
    public RequestInfo.Builder traceContext(TraceContext traceContext) {
      if (traceContext == null) {
        throw new NullPointerException("Null traceContext");
      }
      this.traceContext = traceContext;
      return this;
    }
    @Override
    public RequestInfo.Builder project(Project.NameKey project) {
      this.project = Optional.of(project);
      return this;
    }
    @Override
    public RequestInfo build() {
      if (headersBuilder$ != null) {
        this.headers = headersBuilder$.build();
      } else if (this.headers == null) {
        this.headers = ImmutableList.of();
      }
      if (this.requestType == null
          || this.callingUser == null
          || this.traceContext == null) {
        StringBuilder missing = new StringBuilder();
        if (this.requestType == null) {
          missing.append(" requestType");
        }
        if (this.callingUser == null) {
          missing.append(" callingUser");
        }
        if (this.traceContext == null) {
          missing.append(" traceContext");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RequestInfo(
          this.requestType,
          this.requestUri,
          this.requestQueryString,
          this.headers,
          this.callingUser,
          this.traceContext,
          this.project);
    }
  }

}
