package com.google.gerrit.server;

import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.Address;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ReviewerStatusUpdate extends ReviewerStatusUpdate {

  private final Instant date;

  private final Account.Id updatedBy;

  private final Optional<Account.Id> reviewer;

  private final Optional<Address> reviewerByEmail;

  private final ReviewerStateInternal state;

  AutoValue_ReviewerStatusUpdate(
      Instant date,
      Account.Id updatedBy,
      Optional<Account.Id> reviewer,
      Optional<Address> reviewerByEmail,
      ReviewerStateInternal state) {
    if (date == null) {
      throw new NullPointerException("Null date");
    }
    this.date = date;
    if (updatedBy == null) {
      throw new NullPointerException("Null updatedBy");
    }
    this.updatedBy = updatedBy;
    if (reviewer == null) {
      throw new NullPointerException("Null reviewer");
    }
    this.reviewer = reviewer;
    if (reviewerByEmail == null) {
      throw new NullPointerException("Null reviewerByEmail");
    }
    this.reviewerByEmail = reviewerByEmail;
    if (state == null) {
      throw new NullPointerException("Null state");
    }
    this.state = state;
  }

  @Override
  public Instant date() {
    return date;
  }

  @Override
  public Account.Id updatedBy() {
    return updatedBy;
  }

  @Override
  public Optional<Account.Id> reviewer() {
    return reviewer;
  }

  @Override
  public Optional<Address> reviewerByEmail() {
    return reviewerByEmail;
  }

  @Override
  public ReviewerStateInternal state() {
    return state;
  }

  @Override
  public String toString() {
    return "ReviewerStatusUpdate{"
        + "date=" + date + ", "
        + "updatedBy=" + updatedBy + ", "
        + "reviewer=" + reviewer + ", "
        + "reviewerByEmail=" + reviewerByEmail + ", "
        + "state=" + state
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ReviewerStatusUpdate) {
      ReviewerStatusUpdate that = (ReviewerStatusUpdate) o;
      return this.date.equals(that.date())
          && this.updatedBy.equals(that.updatedBy())
          && this.reviewer.equals(that.reviewer())
          && this.reviewerByEmail.equals(that.reviewerByEmail())
          && this.state.equals(that.state());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= date.hashCode();
    h$ *= 1000003;
    h$ ^= updatedBy.hashCode();
    h$ *= 1000003;
    h$ ^= reviewer.hashCode();
    h$ *= 1000003;
    h$ ^= reviewerByEmail.hashCode();
    h$ *= 1000003;
    h$ ^= state.hashCode();
    return h$;
  }

}
