package com.google.gerrit.server.account;

import com.google.gerrit.entities.Account;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AccountSshKey extends AccountSshKey {

  private final Account.Id accountId;

  private final int seq;

  private final String sshPublicKey;

  private final boolean valid;

  private AutoValue_AccountSshKey(
      Account.Id accountId,
      int seq,
      String sshPublicKey,
      boolean valid) {
    this.accountId = accountId;
    this.seq = seq;
    this.sshPublicKey = sshPublicKey;
    this.valid = valid;
  }

  @Override
  public Account.Id accountId() {
    return accountId;
  }

  @Override
  public int seq() {
    return seq;
  }

  @Override
  public String sshPublicKey() {
    return sshPublicKey;
  }

  @Override
  public boolean valid() {
    return valid;
  }

  @Override
  public String toString() {
    return "AccountSshKey{"
        + "accountId=" + accountId + ", "
        + "seq=" + seq + ", "
        + "sshPublicKey=" + sshPublicKey + ", "
        + "valid=" + valid
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AccountSshKey) {
      AccountSshKey that = (AccountSshKey) o;
      return this.accountId.equals(that.accountId())
          && this.seq == that.seq()
          && this.sshPublicKey.equals(that.sshPublicKey())
          && this.valid == that.valid();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= accountId.hashCode();
    h$ *= 1000003;
    h$ ^= seq;
    h$ *= 1000003;
    h$ ^= sshPublicKey.hashCode();
    h$ *= 1000003;
    h$ ^= valid ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends AccountSshKey.Builder {
    private Account.Id accountId;
    private int seq;
    private String sshPublicKey;
    private boolean valid;
    private byte set$0;
    Builder() {
    }
    @Override
    public AccountSshKey.Builder setAccountId(Account.Id accountId) {
      if (accountId == null) {
        throw new NullPointerException("Null accountId");
      }
      this.accountId = accountId;
      return this;
    }
    @Override
    public AccountSshKey.Builder setSeq(int seq) {
      this.seq = seq;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public AccountSshKey.Builder setSshPublicKey(String sshPublicKey) {
      if (sshPublicKey == null) {
        throw new NullPointerException("Null sshPublicKey");
      }
      this.sshPublicKey = sshPublicKey;
      return this;
    }
    @Override
    public AccountSshKey.Builder setValid(boolean valid) {
      this.valid = valid;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public AccountSshKey build() {
      if (set$0 != 3
          || this.accountId == null
          || this.sshPublicKey == null) {
        StringBuilder missing = new StringBuilder();
        if (this.accountId == null) {
          missing.append(" accountId");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" seq");
        }
        if (this.sshPublicKey == null) {
          missing.append(" sshPublicKey");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" valid");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AccountSshKey(
          this.accountId,
          this.seq,
          this.sshPublicKey,
          this.valid);
    }
  }

}
