package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.entities.Change;
import com.google.gerrit.extensions.common.ProblemInfo;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsistencyChecker_Result extends ConsistencyChecker.Result {

  private final Change.Id id;

  @Nullable
  private final Change change;

  private final ImmutableList<ProblemInfo> problems;

  AutoValue_ConsistencyChecker_Result(
      Change.Id id,
      @Nullable Change change,
      ImmutableList<ProblemInfo> problems) {
    if (id == null) {
      throw new NullPointerException("Null id");
    }
    this.id = id;
    this.change = change;
    if (problems == null) {
      throw new NullPointerException("Null problems");
    }
    this.problems = problems;
  }

  @Override
  public Change.Id id() {
    return id;
  }

  @Nullable
  @Override
  public Change change() {
    return change;
  }

  @Override
  public ImmutableList<ProblemInfo> problems() {
    return problems;
  }

  @Override
  public String toString() {
    return "Result{"
        + "id=" + id + ", "
        + "change=" + change + ", "
        + "problems=" + problems
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsistencyChecker.Result) {
      ConsistencyChecker.Result that = (ConsistencyChecker.Result) o;
      return this.id.equals(that.id())
          && (this.change == null ? that.change() == null : this.change.equals(that.change()))
          && this.problems.equals(that.problems());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= (change == null) ? 0 : change.hashCode();
    h$ *= 1000003;
    h$ ^= problems.hashCode();
    return h$;
  }

}
