package com.google.gerrit.server.config;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.entities.AccountGroup;
import com.google.gerrit.entities.CachedProjectConfig;
import com.google.gerrit.entities.GroupReference;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.Config;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PluginConfig extends PluginConfig {

  private final String pluginName;

  private final Config cfg;

  private final Optional<CachedProjectConfig> projectConfig;

  private final ImmutableMap<AccountGroup.UUID, GroupReference> groupReferences;

  AutoValue_PluginConfig(
      String pluginName,
      Config cfg,
      Optional<CachedProjectConfig> projectConfig,
      ImmutableMap<AccountGroup.UUID, GroupReference> groupReferences) {
    if (pluginName == null) {
      throw new NullPointerException("Null pluginName");
    }
    this.pluginName = pluginName;
    if (cfg == null) {
      throw new NullPointerException("Null cfg");
    }
    this.cfg = cfg;
    if (projectConfig == null) {
      throw new NullPointerException("Null projectConfig");
    }
    this.projectConfig = projectConfig;
    if (groupReferences == null) {
      throw new NullPointerException("Null groupReferences");
    }
    this.groupReferences = groupReferences;
  }

  @Override
  protected String pluginName() {
    return pluginName;
  }

  @Override
  protected Config cfg() {
    return cfg;
  }

  @Override
  protected Optional<CachedProjectConfig> projectConfig() {
    return projectConfig;
  }

  @Override
  protected ImmutableMap<AccountGroup.UUID, GroupReference> groupReferences() {
    return groupReferences;
  }

  @Override
  public String toString() {
    return "PluginConfig{"
        + "pluginName=" + pluginName + ", "
        + "cfg=" + cfg + ", "
        + "projectConfig=" + projectConfig + ", "
        + "groupReferences=" + groupReferences
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PluginConfig) {
      PluginConfig that = (PluginConfig) o;
      return this.pluginName.equals(that.pluginName())
          && this.cfg.equals(that.cfg())
          && this.projectConfig.equals(that.projectConfig())
          && this.groupReferences.equals(that.groupReferences());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= pluginName.hashCode();
    h$ *= 1000003;
    h$ ^= cfg.hashCode();
    h$ *= 1000003;
    h$ ^= projectConfig.hashCode();
    h$ *= 1000003;
    h$ ^= groupReferences.hashCode();
    return h$;
  }

}
