package com.google.gerrit.server.git;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.entities.Change;
import com.google.gerrit.server.ReviewerSet;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ChangesByProjectCacheImpl_PrivateChange extends ChangesByProjectCacheImpl.PrivateChange {

  private final Change change;

  @Nullable
  private final ReviewerSet reviewers;

  private final ObjectId metaRevision;

  AutoValue_ChangesByProjectCacheImpl_PrivateChange(
      Change change,
      @Nullable ReviewerSet reviewers,
      ObjectId metaRevision) {
    if (change == null) {
      throw new NullPointerException("Null change");
    }
    this.change = change;
    this.reviewers = reviewers;
    if (metaRevision == null) {
      throw new NullPointerException("Null metaRevision");
    }
    this.metaRevision = metaRevision;
  }

  @Override
  Change change() {
    return change;
  }

  @Nullable
  @Override
  ReviewerSet reviewers() {
    return reviewers;
  }

  @Override
  ObjectId metaRevision() {
    return metaRevision;
  }

  @Override
  public String toString() {
    return "PrivateChange{"
        + "change=" + change + ", "
        + "reviewers=" + reviewers + ", "
        + "metaRevision=" + metaRevision
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ChangesByProjectCacheImpl.PrivateChange) {
      ChangesByProjectCacheImpl.PrivateChange that = (ChangesByProjectCacheImpl.PrivateChange) o;
      return this.change.equals(that.change())
          && (this.reviewers == null ? that.reviewers() == null : this.reviewers.equals(that.reviewers()))
          && this.metaRevision.equals(that.metaRevision());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= change.hashCode();
    h$ *= 1000003;
    h$ ^= (reviewers == null) ? 0 : reviewers.hashCode();
    h$ *= 1000003;
    h$ ^= metaRevision.hashCode();
    return h$;
  }

}
