package com.google.gerrit.server.group.db;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.AccountGroup;
import java.time.Instant;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AuditLogReader_ParsedCommit extends AuditLogReader.ParsedCommit {

  private final Account.Id authorId;

  private final Instant when;

  private final ImmutableList<Account.Id> addedMembers;

  private final ImmutableList<Account.Id> removedMembers;

  private final ImmutableList<AccountGroup.UUID> addedSubgroups;

  private final ImmutableList<AccountGroup.UUID> removedSubgroups;

  AutoValue_AuditLogReader_ParsedCommit(
      Account.Id authorId,
      Instant when,
      ImmutableList<Account.Id> addedMembers,
      ImmutableList<Account.Id> removedMembers,
      ImmutableList<AccountGroup.UUID> addedSubgroups,
      ImmutableList<AccountGroup.UUID> removedSubgroups) {
    if (authorId == null) {
      throw new NullPointerException("Null authorId");
    }
    this.authorId = authorId;
    if (when == null) {
      throw new NullPointerException("Null when");
    }
    this.when = when;
    if (addedMembers == null) {
      throw new NullPointerException("Null addedMembers");
    }
    this.addedMembers = addedMembers;
    if (removedMembers == null) {
      throw new NullPointerException("Null removedMembers");
    }
    this.removedMembers = removedMembers;
    if (addedSubgroups == null) {
      throw new NullPointerException("Null addedSubgroups");
    }
    this.addedSubgroups = addedSubgroups;
    if (removedSubgroups == null) {
      throw new NullPointerException("Null removedSubgroups");
    }
    this.removedSubgroups = removedSubgroups;
  }

  @Override
  Account.Id authorId() {
    return authorId;
  }

  @Override
  Instant when() {
    return when;
  }

  @Override
  ImmutableList<Account.Id> addedMembers() {
    return addedMembers;
  }

  @Override
  ImmutableList<Account.Id> removedMembers() {
    return removedMembers;
  }

  @Override
  ImmutableList<AccountGroup.UUID> addedSubgroups() {
    return addedSubgroups;
  }

  @Override
  ImmutableList<AccountGroup.UUID> removedSubgroups() {
    return removedSubgroups;
  }

  @Override
  public String toString() {
    return "ParsedCommit{"
        + "authorId=" + authorId + ", "
        + "when=" + when + ", "
        + "addedMembers=" + addedMembers + ", "
        + "removedMembers=" + removedMembers + ", "
        + "addedSubgroups=" + addedSubgroups + ", "
        + "removedSubgroups=" + removedSubgroups
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AuditLogReader.ParsedCommit) {
      AuditLogReader.ParsedCommit that = (AuditLogReader.ParsedCommit) o;
      return this.authorId.equals(that.authorId())
          && this.when.equals(that.when())
          && this.addedMembers.equals(that.addedMembers())
          && this.removedMembers.equals(that.removedMembers())
          && this.addedSubgroups.equals(that.addedSubgroups())
          && this.removedSubgroups.equals(that.removedSubgroups());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= authorId.hashCode();
    h$ *= 1000003;
    h$ ^= when.hashCode();
    h$ *= 1000003;
    h$ ^= addedMembers.hashCode();
    h$ *= 1000003;
    h$ ^= removedMembers.hashCode();
    h$ *= 1000003;
    h$ ^= addedSubgroups.hashCode();
    h$ *= 1000003;
    h$ ^= removedSubgroups.hashCode();
    return h$;
  }

}
