package com.google.gerrit.server.group.db;

import com.google.gerrit.entities.AccountGroup;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_InternalGroupCreation extends InternalGroupCreation {

  private final AccountGroup.Id id;

  private final AccountGroup.NameKey nameKey;

  private final AccountGroup.UUID groupUUID;

  private AutoValue_InternalGroupCreation(
      AccountGroup.Id id,
      AccountGroup.NameKey nameKey,
      AccountGroup.UUID groupUUID) {
    this.id = id;
    this.nameKey = nameKey;
    this.groupUUID = groupUUID;
  }

  @Override
  public AccountGroup.Id getId() {
    return id;
  }

  @Override
  public AccountGroup.NameKey getNameKey() {
    return nameKey;
  }

  @Override
  public AccountGroup.UUID getGroupUUID() {
    return groupUUID;
  }

  @Override
  public String toString() {
    return "InternalGroupCreation{"
        + "id=" + id + ", "
        + "nameKey=" + nameKey + ", "
        + "groupUUID=" + groupUUID
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof InternalGroupCreation) {
      InternalGroupCreation that = (InternalGroupCreation) o;
      return this.id.equals(that.getId())
          && this.nameKey.equals(that.getNameKey())
          && this.groupUUID.equals(that.getGroupUUID());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= nameKey.hashCode();
    h$ *= 1000003;
    h$ ^= groupUUID.hashCode();
    return h$;
  }

  static final class Builder extends InternalGroupCreation.Builder {
    private AccountGroup.Id id;
    private AccountGroup.NameKey nameKey;
    private AccountGroup.UUID groupUUID;
    Builder() {
    }
    @Override
    public InternalGroupCreation.Builder setId(AccountGroup.Id id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public InternalGroupCreation.Builder setNameKey(AccountGroup.NameKey nameKey) {
      if (nameKey == null) {
        throw new NullPointerException("Null nameKey");
      }
      this.nameKey = nameKey;
      return this;
    }
    @Override
    public InternalGroupCreation.Builder setGroupUUID(AccountGroup.UUID groupUUID) {
      if (groupUUID == null) {
        throw new NullPointerException("Null groupUUID");
      }
      this.groupUUID = groupUUID;
      return this;
    }
    @Override
    public InternalGroupCreation build() {
      if (this.id == null
          || this.nameKey == null
          || this.groupUUID == null) {
        StringBuilder missing = new StringBuilder();
        if (this.id == null) {
          missing.append(" id");
        }
        if (this.nameKey == null) {
          missing.append(" nameKey");
        }
        if (this.groupUUID == null) {
          missing.append(" groupUUID");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_InternalGroupCreation(
          this.id,
          this.nameKey,
          this.groupUUID);
    }
  }

}
