package com.google.gerrit.server.index.change;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.entities.Change;
import com.google.gerrit.entities.Project;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AllChangesIndexer_ProjectSlice extends AllChangesIndexer.ProjectSlice {

  private final Project.NameKey name;

  private final int slice;

  private final int slices;

  private final ImmutableMap<Change.Id, ObjectId> metaIdByChange;

  AutoValue_AllChangesIndexer_ProjectSlice(
      Project.NameKey name,
      int slice,
      int slices,
      ImmutableMap<Change.Id, ObjectId> metaIdByChange) {
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    this.slice = slice;
    this.slices = slices;
    if (metaIdByChange == null) {
      throw new NullPointerException("Null metaIdByChange");
    }
    this.metaIdByChange = metaIdByChange;
  }

  @Override
  public Project.NameKey name() {
    return name;
  }

  @Override
  public int slice() {
    return slice;
  }

  @Override
  public int slices() {
    return slices;
  }

  @Override
  public ImmutableMap<Change.Id, ObjectId> metaIdByChange() {
    return metaIdByChange;
  }

  @Override
  public String toString() {
    return "ProjectSlice{"
        + "name=" + name + ", "
        + "slice=" + slice + ", "
        + "slices=" + slices + ", "
        + "metaIdByChange=" + metaIdByChange
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AllChangesIndexer.ProjectSlice) {
      AllChangesIndexer.ProjectSlice that = (AllChangesIndexer.ProjectSlice) o;
      return this.name.equals(that.name())
          && this.slice == that.slice()
          && this.slices == that.slices()
          && this.metaIdByChange.equals(that.metaIdByChange());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= slice;
    h$ *= 1000003;
    h$ ^= slices;
    h$ *= 1000003;
    h$ ^= metaIdByChange.hashCode();
    return h$;
  }

}
