package com.google.gerrit.server.mail.send;

import com.google.gerrit.entities.Change;
import com.google.gerrit.entities.Project;
import com.google.gerrit.entities.SubmitRequirement;
import com.google.gerrit.entities.SubmitRequirementResult;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import java.util.Map;
import javax.annotation.processing.Generated;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;

@Generated(
    value = "com.google.auto.factory.processor.AutoFactoryProcessor",
    comments = "https://github.com/google/auto/tree/master/factory"
)
public final class CommentChangeEmailDecoratorImplFactory {
  private final Provider<EmailArguments> argsProvider;

  private final Provider<CommentsUtil> commentsUtilProvider;

  private final Provider<Config> cfgProvider;

  @Inject
  public CommentChangeEmailDecoratorImplFactory(Provider<EmailArguments> argsProvider,
      Provider<CommentsUtil> commentsUtilProvider,
      @GerritServerConfig Provider<Config> cfgProvider) {
    this.argsProvider = checkNotNull(argsProvider, 1);
    this.commentsUtilProvider = checkNotNull(commentsUtilProvider, 2);
    this.cfgProvider = checkNotNull(cfgProvider, 3);
  }

  public CommentChangeEmailDecoratorImpl create(Project.NameKey project, Change.Id changeId,
      ObjectId preUpdateMetaId,
      Map<SubmitRequirement, SubmitRequirementResult> postUpdateSubmitRequirementResults) {
    return new CommentChangeEmailDecoratorImpl(checkNotNull(argsProvider.get(), 1), checkNotNull(commentsUtilProvider.get(), 2), checkNotNull(cfgProvider.get(), 3), checkNotNull(project, 4), checkNotNull(changeId, 5), checkNotNull(preUpdateMetaId, 6), checkNotNull(postUpdateSubmitRequirementResults, 7));
  }

  private static <T> T checkNotNull(T reference, int argumentIndex) {
    if (reference == null) {
      throw new NullPointerException("@AutoFactory method argument is null but is not marked @Nullable. Argument index: " + argumentIndex);
    }
    return reference;
  }
}
