package com.google.gerrit.server.notedb;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.Change;
import com.google.gerrit.entities.PatchSet;
import java.time.Instant;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ChangeNotesState_ChangeColumns extends ChangeNotesState.ChangeColumns {

  private final Change.Key changeKey;

  private final Instant createdOn;

  private final Instant lastUpdatedOn;

  private final Account.Id owner;

  private final String branch;

  @Nullable
  private final Change.Status status;

  @Nullable
  private final PatchSet.Id currentPatchSetId;

  private final String subject;

  @Nullable
  private final String topic;

  @Nullable
  private final String originalSubject;

  @Nullable
  private final String submissionId;

  private final boolean isPrivate;

  private final boolean workInProgress;

  private final boolean reviewStarted;

  @Nullable
  private final Change.Id revertOf;

  @Nullable
  private final PatchSet.Id cherryPickOf;

  private AutoValue_ChangeNotesState_ChangeColumns(
      Change.Key changeKey,
      Instant createdOn,
      Instant lastUpdatedOn,
      Account.Id owner,
      String branch,
      @Nullable Change.Status status,
      @Nullable PatchSet.Id currentPatchSetId,
      String subject,
      @Nullable String topic,
      @Nullable String originalSubject,
      @Nullable String submissionId,
      boolean isPrivate,
      boolean workInProgress,
      boolean reviewStarted,
      @Nullable Change.Id revertOf,
      @Nullable PatchSet.Id cherryPickOf) {
    this.changeKey = changeKey;
    this.createdOn = createdOn;
    this.lastUpdatedOn = lastUpdatedOn;
    this.owner = owner;
    this.branch = branch;
    this.status = status;
    this.currentPatchSetId = currentPatchSetId;
    this.subject = subject;
    this.topic = topic;
    this.originalSubject = originalSubject;
    this.submissionId = submissionId;
    this.isPrivate = isPrivate;
    this.workInProgress = workInProgress;
    this.reviewStarted = reviewStarted;
    this.revertOf = revertOf;
    this.cherryPickOf = cherryPickOf;
  }

  @Override
  Change.Key changeKey() {
    return changeKey;
  }

  @Override
  Instant createdOn() {
    return createdOn;
  }

  @Override
  Instant lastUpdatedOn() {
    return lastUpdatedOn;
  }

  @Override
  Account.Id owner() {
    return owner;
  }

  @Override
  String branch() {
    return branch;
  }

  @Nullable
  @Override
  Change.Status status() {
    return status;
  }

  @Nullable
  @Override
  PatchSet.Id currentPatchSetId() {
    return currentPatchSetId;
  }

  @Override
  String subject() {
    return subject;
  }

  @Nullable
  @Override
  String topic() {
    return topic;
  }

  @Nullable
  @Override
  String originalSubject() {
    return originalSubject;
  }

  @Nullable
  @Override
  String submissionId() {
    return submissionId;
  }

  @Override
  boolean isPrivate() {
    return isPrivate;
  }

  @Override
  boolean workInProgress() {
    return workInProgress;
  }

  @Override
  boolean reviewStarted() {
    return reviewStarted;
  }

  @Nullable
  @Override
  Change.Id revertOf() {
    return revertOf;
  }

  @Nullable
  @Override
  PatchSet.Id cherryPickOf() {
    return cherryPickOf;
  }

  @Override
  public String toString() {
    return "ChangeColumns{"
        + "changeKey=" + changeKey + ", "
        + "createdOn=" + createdOn + ", "
        + "lastUpdatedOn=" + lastUpdatedOn + ", "
        + "owner=" + owner + ", "
        + "branch=" + branch + ", "
        + "status=" + status + ", "
        + "currentPatchSetId=" + currentPatchSetId + ", "
        + "subject=" + subject + ", "
        + "topic=" + topic + ", "
        + "originalSubject=" + originalSubject + ", "
        + "submissionId=" + submissionId + ", "
        + "isPrivate=" + isPrivate + ", "
        + "workInProgress=" + workInProgress + ", "
        + "reviewStarted=" + reviewStarted + ", "
        + "revertOf=" + revertOf + ", "
        + "cherryPickOf=" + cherryPickOf
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ChangeNotesState.ChangeColumns) {
      ChangeNotesState.ChangeColumns that = (ChangeNotesState.ChangeColumns) o;
      return this.changeKey.equals(that.changeKey())
          && this.createdOn.equals(that.createdOn())
          && this.lastUpdatedOn.equals(that.lastUpdatedOn())
          && this.owner.equals(that.owner())
          && this.branch.equals(that.branch())
          && (this.status == null ? that.status() == null : this.status.equals(that.status()))
          && (this.currentPatchSetId == null ? that.currentPatchSetId() == null : this.currentPatchSetId.equals(that.currentPatchSetId()))
          && this.subject.equals(that.subject())
          && (this.topic == null ? that.topic() == null : this.topic.equals(that.topic()))
          && (this.originalSubject == null ? that.originalSubject() == null : this.originalSubject.equals(that.originalSubject()))
          && (this.submissionId == null ? that.submissionId() == null : this.submissionId.equals(that.submissionId()))
          && this.isPrivate == that.isPrivate()
          && this.workInProgress == that.workInProgress()
          && this.reviewStarted == that.reviewStarted()
          && (this.revertOf == null ? that.revertOf() == null : this.revertOf.equals(that.revertOf()))
          && (this.cherryPickOf == null ? that.cherryPickOf() == null : this.cherryPickOf.equals(that.cherryPickOf()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= changeKey.hashCode();
    h$ *= 1000003;
    h$ ^= createdOn.hashCode();
    h$ *= 1000003;
    h$ ^= lastUpdatedOn.hashCode();
    h$ *= 1000003;
    h$ ^= owner.hashCode();
    h$ *= 1000003;
    h$ ^= branch.hashCode();
    h$ *= 1000003;
    h$ ^= (status == null) ? 0 : status.hashCode();
    h$ *= 1000003;
    h$ ^= (currentPatchSetId == null) ? 0 : currentPatchSetId.hashCode();
    h$ *= 1000003;
    h$ ^= subject.hashCode();
    h$ *= 1000003;
    h$ ^= (topic == null) ? 0 : topic.hashCode();
    h$ *= 1000003;
    h$ ^= (originalSubject == null) ? 0 : originalSubject.hashCode();
    h$ *= 1000003;
    h$ ^= (submissionId == null) ? 0 : submissionId.hashCode();
    h$ *= 1000003;
    h$ ^= isPrivate ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= workInProgress ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= reviewStarted ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (revertOf == null) ? 0 : revertOf.hashCode();
    h$ *= 1000003;
    h$ ^= (cherryPickOf == null) ? 0 : cherryPickOf.hashCode();
    return h$;
  }

  @Override
  ChangeNotesState.ChangeColumns.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ChangeNotesState.ChangeColumns.Builder {
    private Change.Key changeKey;
    private Instant createdOn;
    private Instant lastUpdatedOn;
    private Account.Id owner;
    private String branch;
    private Change.Status status;
    private PatchSet.Id currentPatchSetId;
    private String subject;
    private String topic;
    private String originalSubject;
    private String submissionId;
    private boolean isPrivate;
    private boolean workInProgress;
    private boolean reviewStarted;
    private Change.Id revertOf;
    private PatchSet.Id cherryPickOf;
    private byte set$0;
    Builder() {
    }
    private Builder(ChangeNotesState.ChangeColumns source) {
      this.changeKey = source.changeKey();
      this.createdOn = source.createdOn();
      this.lastUpdatedOn = source.lastUpdatedOn();
      this.owner = source.owner();
      this.branch = source.branch();
      this.status = source.status();
      this.currentPatchSetId = source.currentPatchSetId();
      this.subject = source.subject();
      this.topic = source.topic();
      this.originalSubject = source.originalSubject();
      this.submissionId = source.submissionId();
      this.isPrivate = source.isPrivate();
      this.workInProgress = source.workInProgress();
      this.reviewStarted = source.reviewStarted();
      this.revertOf = source.revertOf();
      this.cherryPickOf = source.cherryPickOf();
      set$0 = (byte) 7;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder changeKey(Change.Key changeKey) {
      if (changeKey == null) {
        throw new NullPointerException("Null changeKey");
      }
      this.changeKey = changeKey;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder createdOn(Instant createdOn) {
      if (createdOn == null) {
        throw new NullPointerException("Null createdOn");
      }
      this.createdOn = createdOn;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder lastUpdatedOn(Instant lastUpdatedOn) {
      if (lastUpdatedOn == null) {
        throw new NullPointerException("Null lastUpdatedOn");
      }
      this.lastUpdatedOn = lastUpdatedOn;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder owner(Account.Id owner) {
      if (owner == null) {
        throw new NullPointerException("Null owner");
      }
      this.owner = owner;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder branch(String branch) {
      if (branch == null) {
        throw new NullPointerException("Null branch");
      }
      this.branch = branch;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder status(@Nullable Change.Status status) {
      this.status = status;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder currentPatchSetId(@Nullable PatchSet.Id currentPatchSetId) {
      this.currentPatchSetId = currentPatchSetId;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder subject(String subject) {
      if (subject == null) {
        throw new NullPointerException("Null subject");
      }
      this.subject = subject;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder topic(@Nullable String topic) {
      this.topic = topic;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder originalSubject(@Nullable String originalSubject) {
      this.originalSubject = originalSubject;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder submissionId(@Nullable String submissionId) {
      this.submissionId = submissionId;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder isPrivate(boolean isPrivate) {
      this.isPrivate = isPrivate;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder workInProgress(boolean workInProgress) {
      this.workInProgress = workInProgress;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder reviewStarted(boolean reviewStarted) {
      this.reviewStarted = reviewStarted;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder revertOf(@Nullable Change.Id revertOf) {
      this.revertOf = revertOf;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns.Builder cherryPickOf(@Nullable PatchSet.Id cherryPickOf) {
      this.cherryPickOf = cherryPickOf;
      return this;
    }
    @Override
    ChangeNotesState.ChangeColumns build() {
      if (set$0 != 7
          || this.changeKey == null
          || this.createdOn == null
          || this.lastUpdatedOn == null
          || this.owner == null
          || this.branch == null
          || this.subject == null) {
        StringBuilder missing = new StringBuilder();
        if (this.changeKey == null) {
          missing.append(" changeKey");
        }
        if (this.createdOn == null) {
          missing.append(" createdOn");
        }
        if (this.lastUpdatedOn == null) {
          missing.append(" lastUpdatedOn");
        }
        if (this.owner == null) {
          missing.append(" owner");
        }
        if (this.branch == null) {
          missing.append(" branch");
        }
        if (this.subject == null) {
          missing.append(" subject");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isPrivate");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" workInProgress");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" reviewStarted");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ChangeNotesState_ChangeColumns(
          this.changeKey,
          this.createdOn,
          this.lastUpdatedOn,
          this.owner,
          this.branch,
          this.status,
          this.currentPatchSetId,
          this.subject,
          this.topic,
          this.originalSubject,
          this.submissionId,
          this.isPrivate,
          this.workInProgress,
          this.reviewStarted,
          this.revertOf,
          this.cherryPickOf);
    }
  }

}
