package com.google.gerrit.server.patch;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.entities.Project;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_DiffOperationsImpl_DiffParameters extends DiffOperationsImpl.DiffParameters {

  private final Project.NameKey project;

  private final ObjectId newCommit;

  private final ObjectId baseCommit;

  private final ComparisonType comparisonType;

  @Nullable
  private final Integer parent;

  @Nullable
  private final Boolean skipFiles;

  private AutoValue_DiffOperationsImpl_DiffParameters(
      Project.NameKey project,
      ObjectId newCommit,
      ObjectId baseCommit,
      ComparisonType comparisonType,
      @Nullable Integer parent,
      @Nullable Boolean skipFiles) {
    this.project = project;
    this.newCommit = newCommit;
    this.baseCommit = baseCommit;
    this.comparisonType = comparisonType;
    this.parent = parent;
    this.skipFiles = skipFiles;
  }

  @Override
  Project.NameKey project() {
    return project;
  }

  @Override
  ObjectId newCommit() {
    return newCommit;
  }

  @Override
  ObjectId baseCommit() {
    return baseCommit;
  }

  @Override
  ComparisonType comparisonType() {
    return comparisonType;
  }

  @Nullable
  @Override
  Integer parent() {
    return parent;
  }

  @Nullable
  @Override
  Boolean skipFiles() {
    return skipFiles;
  }

  @Override
  public String toString() {
    return "DiffParameters{"
        + "project=" + project + ", "
        + "newCommit=" + newCommit + ", "
        + "baseCommit=" + baseCommit + ", "
        + "comparisonType=" + comparisonType + ", "
        + "parent=" + parent + ", "
        + "skipFiles=" + skipFiles
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DiffOperationsImpl.DiffParameters) {
      DiffOperationsImpl.DiffParameters that = (DiffOperationsImpl.DiffParameters) o;
      return this.project.equals(that.project())
          && this.newCommit.equals(that.newCommit())
          && this.baseCommit.equals(that.baseCommit())
          && this.comparisonType.equals(that.comparisonType())
          && (this.parent == null ? that.parent() == null : this.parent.equals(that.parent()))
          && (this.skipFiles == null ? that.skipFiles() == null : this.skipFiles.equals(that.skipFiles()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= newCommit.hashCode();
    h$ *= 1000003;
    h$ ^= baseCommit.hashCode();
    h$ *= 1000003;
    h$ ^= comparisonType.hashCode();
    h$ *= 1000003;
    h$ ^= (parent == null) ? 0 : parent.hashCode();
    h$ *= 1000003;
    h$ ^= (skipFiles == null) ? 0 : skipFiles.hashCode();
    return h$;
  }

  static final class Builder extends DiffOperationsImpl.DiffParameters.Builder {
    private Project.NameKey project;
    private ObjectId newCommit;
    private ObjectId baseCommit;
    private ComparisonType comparisonType;
    private Integer parent;
    private Boolean skipFiles;
    Builder() {
    }
    @Override
    DiffOperationsImpl.DiffParameters.Builder project(Project.NameKey project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    DiffOperationsImpl.DiffParameters.Builder newCommit(ObjectId newCommit) {
      if (newCommit == null) {
        throw new NullPointerException("Null newCommit");
      }
      this.newCommit = newCommit;
      return this;
    }
    @Override
    DiffOperationsImpl.DiffParameters.Builder baseCommit(ObjectId baseCommit) {
      if (baseCommit == null) {
        throw new NullPointerException("Null baseCommit");
      }
      this.baseCommit = baseCommit;
      return this;
    }
    @Override
    DiffOperationsImpl.DiffParameters.Builder comparisonType(ComparisonType comparisonType) {
      if (comparisonType == null) {
        throw new NullPointerException("Null comparisonType");
      }
      this.comparisonType = comparisonType;
      return this;
    }
    @Override
    DiffOperationsImpl.DiffParameters.Builder parent(@Nullable Integer parent) {
      this.parent = parent;
      return this;
    }
    @Override
    DiffOperationsImpl.DiffParameters.Builder skipFiles(@Nullable Boolean skipFiles) {
      this.skipFiles = skipFiles;
      return this;
    }
    @Override
    public DiffOperationsImpl.DiffParameters build() {
      if (this.project == null
          || this.newCommit == null
          || this.baseCommit == null
          || this.comparisonType == null) {
        StringBuilder missing = new StringBuilder();
        if (this.project == null) {
          missing.append(" project");
        }
        if (this.newCommit == null) {
          missing.append(" newCommit");
        }
        if (this.baseCommit == null) {
          missing.append(" baseCommit");
        }
        if (this.comparisonType == null) {
          missing.append(" comparisonType");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DiffOperationsImpl_DiffParameters(
          this.project,
          this.newCommit,
          this.baseCommit,
          this.comparisonType,
          this.parent,
          this.skipFiles);
    }
  }

}
