package com.google.gerrit.server.patch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.entities.Project;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_IntraLineDiffArgs extends IntraLineDiffArgs {

  private final Text aText;

  private final Text bText;

  private final ImmutableList<Edit> edits;

  private final ImmutableSet<Edit> editsDueToRebase;

  private final Project.NameKey project;

  private final ObjectId commit;

  private final String path;

  AutoValue_IntraLineDiffArgs(
      Text aText,
      Text bText,
      ImmutableList<Edit> edits,
      ImmutableSet<Edit> editsDueToRebase,
      Project.NameKey project,
      ObjectId commit,
      String path) {
    if (aText == null) {
      throw new NullPointerException("Null aText");
    }
    this.aText = aText;
    if (bText == null) {
      throw new NullPointerException("Null bText");
    }
    this.bText = bText;
    if (edits == null) {
      throw new NullPointerException("Null edits");
    }
    this.edits = edits;
    if (editsDueToRebase == null) {
      throw new NullPointerException("Null editsDueToRebase");
    }
    this.editsDueToRebase = editsDueToRebase;
    if (project == null) {
      throw new NullPointerException("Null project");
    }
    this.project = project;
    if (commit == null) {
      throw new NullPointerException("Null commit");
    }
    this.commit = commit;
    if (path == null) {
      throw new NullPointerException("Null path");
    }
    this.path = path;
  }

  @Override
  public Text aText() {
    return aText;
  }

  @Override
  public Text bText() {
    return bText;
  }

  @Override
  public ImmutableList<Edit> edits() {
    return edits;
  }

  @Override
  public ImmutableSet<Edit> editsDueToRebase() {
    return editsDueToRebase;
  }

  @Override
  public Project.NameKey project() {
    return project;
  }

  @Override
  public ObjectId commit() {
    return commit;
  }

  @Override
  public String path() {
    return path;
  }

  @Override
  public String toString() {
    return "IntraLineDiffArgs{"
        + "aText=" + aText + ", "
        + "bText=" + bText + ", "
        + "edits=" + edits + ", "
        + "editsDueToRebase=" + editsDueToRebase + ", "
        + "project=" + project + ", "
        + "commit=" + commit + ", "
        + "path=" + path
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IntraLineDiffArgs) {
      IntraLineDiffArgs that = (IntraLineDiffArgs) o;
      return this.aText.equals(that.aText())
          && this.bText.equals(that.bText())
          && this.edits.equals(that.edits())
          && this.editsDueToRebase.equals(that.editsDueToRebase())
          && this.project.equals(that.project())
          && this.commit.equals(that.commit())
          && this.path.equals(that.path());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= aText.hashCode();
    h$ *= 1000003;
    h$ ^= bText.hashCode();
    h$ *= 1000003;
    h$ ^= edits.hashCode();
    h$ *= 1000003;
    h$ ^= editsDueToRebase.hashCode();
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= commit.hashCode();
    h$ *= 1000003;
    h$ ^= path.hashCode();
    return h$;
  }

}
