package com.google.gerrit.server.patch.diff;

import com.google.gerrit.entities.Project;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ModifiedFilesCacheKey extends ModifiedFilesCacheKey {

  private final Project.NameKey project;

  private final ObjectId aCommit;

  private final ObjectId bCommit;

  private final int renameScore;

  private AutoValue_ModifiedFilesCacheKey(
      Project.NameKey project,
      ObjectId aCommit,
      ObjectId bCommit,
      int renameScore) {
    this.project = project;
    this.aCommit = aCommit;
    this.bCommit = bCommit;
    this.renameScore = renameScore;
  }

  @Override
  public Project.NameKey project() {
    return project;
  }

  @Override
  public ObjectId aCommit() {
    return aCommit;
  }

  @Override
  public ObjectId bCommit() {
    return bCommit;
  }

  @Override
  public int renameScore() {
    return renameScore;
  }

  @Override
  public String toString() {
    return "ModifiedFilesCacheKey{"
        + "project=" + project + ", "
        + "aCommit=" + aCommit + ", "
        + "bCommit=" + bCommit + ", "
        + "renameScore=" + renameScore
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ModifiedFilesCacheKey) {
      ModifiedFilesCacheKey that = (ModifiedFilesCacheKey) o;
      return this.project.equals(that.project())
          && this.aCommit.equals(that.aCommit())
          && this.bCommit.equals(that.bCommit())
          && this.renameScore == that.renameScore();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= aCommit.hashCode();
    h$ *= 1000003;
    h$ ^= bCommit.hashCode();
    h$ *= 1000003;
    h$ ^= renameScore;
    return h$;
  }

  static final class Builder extends ModifiedFilesCacheKey.Builder {
    private Project.NameKey project;
    private ObjectId aCommit;
    private ObjectId bCommit;
    private int renameScore;
    private byte set$0;
    Builder() {
    }
    @Override
    public ModifiedFilesCacheKey.Builder project(Project.NameKey project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    public ModifiedFilesCacheKey.Builder aCommit(ObjectId aCommit) {
      if (aCommit == null) {
        throw new NullPointerException("Null aCommit");
      }
      this.aCommit = aCommit;
      return this;
    }
    @Override
    public ModifiedFilesCacheKey.Builder bCommit(ObjectId bCommit) {
      if (bCommit == null) {
        throw new NullPointerException("Null bCommit");
      }
      this.bCommit = bCommit;
      return this;
    }
    @Override
    public ModifiedFilesCacheKey.Builder renameScore(int renameScore) {
      this.renameScore = renameScore;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public ModifiedFilesCacheKey build() {
      if (set$0 != 1
          || this.project == null
          || this.aCommit == null
          || this.bCommit == null) {
        StringBuilder missing = new StringBuilder();
        if (this.project == null) {
          missing.append(" project");
        }
        if (this.aCommit == null) {
          missing.append(" aCommit");
        }
        if (this.bCommit == null) {
          missing.append(" bCommit");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" renameScore");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ModifiedFilesCacheKey(
          this.project,
          this.aCommit,
          this.bCommit,
          this.renameScore);
    }
  }

}
