package com.google.gerrit.server.patch.filediff;

import com.google.gerrit.entities.Project;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.server.patch.gitfilediff.GitFileDiffCacheImpl;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FileDiffCacheKey extends FileDiffCacheKey {

  private final Project.NameKey project;

  private final ObjectId oldCommit;

  private final ObjectId newCommit;

  private final String newFilePath;

  private final int renameScore;

  private final GitFileDiffCacheImpl.DiffAlgorithm diffAlgorithm;

  private final DiffPreferencesInfo.Whitespace whitespace;

  private final boolean useTimeout;

  private AutoValue_FileDiffCacheKey(
      Project.NameKey project,
      ObjectId oldCommit,
      ObjectId newCommit,
      String newFilePath,
      int renameScore,
      GitFileDiffCacheImpl.DiffAlgorithm diffAlgorithm,
      DiffPreferencesInfo.Whitespace whitespace,
      boolean useTimeout) {
    this.project = project;
    this.oldCommit = oldCommit;
    this.newCommit = newCommit;
    this.newFilePath = newFilePath;
    this.renameScore = renameScore;
    this.diffAlgorithm = diffAlgorithm;
    this.whitespace = whitespace;
    this.useTimeout = useTimeout;
  }

  @Override
  public Project.NameKey project() {
    return project;
  }

  @Override
  public ObjectId oldCommit() {
    return oldCommit;
  }

  @Override
  public ObjectId newCommit() {
    return newCommit;
  }

  @Override
  public String newFilePath() {
    return newFilePath;
  }

  @Override
  public int renameScore() {
    return renameScore;
  }

  @Override
  public GitFileDiffCacheImpl.DiffAlgorithm diffAlgorithm() {
    return diffAlgorithm;
  }

  @Override
  public DiffPreferencesInfo.Whitespace whitespace() {
    return whitespace;
  }

  @Override
  public boolean useTimeout() {
    return useTimeout;
  }

  @Override
  public String toString() {
    return "FileDiffCacheKey{"
        + "project=" + project + ", "
        + "oldCommit=" + oldCommit + ", "
        + "newCommit=" + newCommit + ", "
        + "newFilePath=" + newFilePath + ", "
        + "renameScore=" + renameScore + ", "
        + "diffAlgorithm=" + diffAlgorithm + ", "
        + "whitespace=" + whitespace + ", "
        + "useTimeout=" + useTimeout
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FileDiffCacheKey) {
      FileDiffCacheKey that = (FileDiffCacheKey) o;
      return this.project.equals(that.project())
          && this.oldCommit.equals(that.oldCommit())
          && this.newCommit.equals(that.newCommit())
          && this.newFilePath.equals(that.newFilePath())
          && this.renameScore == that.renameScore()
          && this.diffAlgorithm.equals(that.diffAlgorithm())
          && this.whitespace.equals(that.whitespace())
          && this.useTimeout == that.useTimeout();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= oldCommit.hashCode();
    h$ *= 1000003;
    h$ ^= newCommit.hashCode();
    h$ *= 1000003;
    h$ ^= newFilePath.hashCode();
    h$ *= 1000003;
    h$ ^= renameScore;
    h$ *= 1000003;
    h$ ^= diffAlgorithm.hashCode();
    h$ *= 1000003;
    h$ ^= whitespace.hashCode();
    h$ *= 1000003;
    h$ ^= useTimeout ? 1231 : 1237;
    return h$;
  }

  @Override
  public FileDiffCacheKey.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends FileDiffCacheKey.Builder {
    private Project.NameKey project;
    private ObjectId oldCommit;
    private ObjectId newCommit;
    private String newFilePath;
    private int renameScore;
    private GitFileDiffCacheImpl.DiffAlgorithm diffAlgorithm;
    private DiffPreferencesInfo.Whitespace whitespace;
    private boolean useTimeout;
    private byte set$0;
    Builder() {
    }
    private Builder(FileDiffCacheKey source) {
      this.project = source.project();
      this.oldCommit = source.oldCommit();
      this.newCommit = source.newCommit();
      this.newFilePath = source.newFilePath();
      this.renameScore = source.renameScore();
      this.diffAlgorithm = source.diffAlgorithm();
      this.whitespace = source.whitespace();
      this.useTimeout = source.useTimeout();
      set$0 = (byte) 3;
    }
    @Override
    public FileDiffCacheKey.Builder project(Project.NameKey project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    public FileDiffCacheKey.Builder oldCommit(ObjectId oldCommit) {
      if (oldCommit == null) {
        throw new NullPointerException("Null oldCommit");
      }
      this.oldCommit = oldCommit;
      return this;
    }
    @Override
    public FileDiffCacheKey.Builder newCommit(ObjectId newCommit) {
      if (newCommit == null) {
        throw new NullPointerException("Null newCommit");
      }
      this.newCommit = newCommit;
      return this;
    }
    @Override
    public FileDiffCacheKey.Builder newFilePath(String newFilePath) {
      if (newFilePath == null) {
        throw new NullPointerException("Null newFilePath");
      }
      this.newFilePath = newFilePath;
      return this;
    }
    @Override
    public FileDiffCacheKey.Builder renameScore(int renameScore) {
      this.renameScore = renameScore;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public FileDiffCacheKey.Builder diffAlgorithm(GitFileDiffCacheImpl.DiffAlgorithm diffAlgorithm) {
      if (diffAlgorithm == null) {
        throw new NullPointerException("Null diffAlgorithm");
      }
      this.diffAlgorithm = diffAlgorithm;
      return this;
    }
    @Override
    public FileDiffCacheKey.Builder whitespace(DiffPreferencesInfo.Whitespace whitespace) {
      if (whitespace == null) {
        throw new NullPointerException("Null whitespace");
      }
      this.whitespace = whitespace;
      return this;
    }
    @Override
    public FileDiffCacheKey.Builder useTimeout(boolean useTimeout) {
      this.useTimeout = useTimeout;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public FileDiffCacheKey build() {
      if (set$0 != 3
          || this.project == null
          || this.oldCommit == null
          || this.newCommit == null
          || this.newFilePath == null
          || this.diffAlgorithm == null
          || this.whitespace == null) {
        StringBuilder missing = new StringBuilder();
        if (this.project == null) {
          missing.append(" project");
        }
        if (this.oldCommit == null) {
          missing.append(" oldCommit");
        }
        if (this.newCommit == null) {
          missing.append(" newCommit");
        }
        if (this.newFilePath == null) {
          missing.append(" newFilePath");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" renameScore");
        }
        if (this.diffAlgorithm == null) {
          missing.append(" diffAlgorithm");
        }
        if (this.whitespace == null) {
          missing.append(" whitespace");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" useTimeout");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FileDiffCacheKey(
          this.project,
          this.oldCommit,
          this.newCommit,
          this.newFilePath,
          this.renameScore,
          this.diffAlgorithm,
          this.whitespace,
          this.useTimeout);
    }
  }

}
