package com.google.gerrit.server.permissions;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PermissionBackend_RefFilterOptions extends PermissionBackend.RefFilterOptions {

  private final boolean filterMeta;

  private final ImmutableList<String> prefixes;

  private AutoValue_PermissionBackend_RefFilterOptions(
      boolean filterMeta,
      ImmutableList<String> prefixes) {
    this.filterMeta = filterMeta;
    this.prefixes = prefixes;
  }

  @Override
  public boolean filterMeta() {
    return filterMeta;
  }

  @Override
  public ImmutableList<String> prefixes() {
    return prefixes;
  }

  @Override
  public String toString() {
    return "RefFilterOptions{"
        + "filterMeta=" + filterMeta + ", "
        + "prefixes=" + prefixes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PermissionBackend.RefFilterOptions) {
      PermissionBackend.RefFilterOptions that = (PermissionBackend.RefFilterOptions) o;
      return this.filterMeta == that.filterMeta()
          && this.prefixes.equals(that.prefixes());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= filterMeta ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= prefixes.hashCode();
    return h$;
  }

  @Override
  public PermissionBackend.RefFilterOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends PermissionBackend.RefFilterOptions.Builder {
    private boolean filterMeta;
    private ImmutableList<String> prefixes;
    private byte set$0;
    Builder() {
    }
    private Builder(PermissionBackend.RefFilterOptions source) {
      this.filterMeta = source.filterMeta();
      this.prefixes = source.prefixes();
      set$0 = (byte) 1;
    }
    @Override
    public PermissionBackend.RefFilterOptions.Builder setFilterMeta(boolean filterMeta) {
      this.filterMeta = filterMeta;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public PermissionBackend.RefFilterOptions.Builder setPrefixes(List<String> prefixes) {
      this.prefixes = ImmutableList.copyOf(prefixes);
      return this;
    }
    @Override
    public PermissionBackend.RefFilterOptions build() {
      if (set$0 != 1
          || this.prefixes == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" filterMeta");
        }
        if (this.prefixes == null) {
          missing.append(" prefixes");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PermissionBackend_RefFilterOptions(
          this.filterMeta,
          this.prefixes);
    }
  }

}
