package com.google.gerrit.server.query.change;

import com.google.gerrit.extensions.client.SubmitType;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConflictKey extends ConflictKey {

  private final ObjectId commit;

  private final ObjectId otherCommit;

  private final SubmitType submitType;

  private final boolean contentMerge;

  AutoValue_ConflictKey(
      ObjectId commit,
      ObjectId otherCommit,
      SubmitType submitType,
      boolean contentMerge) {
    if (commit == null) {
      throw new NullPointerException("Null commit");
    }
    this.commit = commit;
    if (otherCommit == null) {
      throw new NullPointerException("Null otherCommit");
    }
    this.otherCommit = otherCommit;
    if (submitType == null) {
      throw new NullPointerException("Null submitType");
    }
    this.submitType = submitType;
    this.contentMerge = contentMerge;
  }

  @Override
  public ObjectId commit() {
    return commit;
  }

  @Override
  public ObjectId otherCommit() {
    return otherCommit;
  }

  @Override
  public SubmitType submitType() {
    return submitType;
  }

  @Override
  public boolean contentMerge() {
    return contentMerge;
  }

  @Override
  public String toString() {
    return "ConflictKey{"
        + "commit=" + commit + ", "
        + "otherCommit=" + otherCommit + ", "
        + "submitType=" + submitType + ", "
        + "contentMerge=" + contentMerge
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConflictKey) {
      ConflictKey that = (ConflictKey) o;
      return this.commit.equals(that.commit())
          && this.otherCommit.equals(that.otherCommit())
          && this.submitType.equals(that.submitType())
          && this.contentMerge == that.contentMerge();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= commit.hashCode();
    h$ *= 1000003;
    h$ ^= otherCommit.hashCode();
    h$ *= 1000003;
    h$ ^= submitType.hashCode();
    h$ *= 1000003;
    h$ ^= contentMerge ? 1231 : 1237;
    return h$;
  }

}
