package com.google.gerrit.server.quota;

import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.Change;
import com.google.gerrit.entities.Project;
import com.google.gerrit.server.CurrentUser;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QuotaRequestContext extends QuotaRequestContext {

  private final CurrentUser user;

  private final Optional<Project.NameKey> project;

  private final Optional<Change.Id> change;

  private final Optional<Account.Id> account;

  private AutoValue_QuotaRequestContext(
      CurrentUser user,
      Optional<Project.NameKey> project,
      Optional<Change.Id> change,
      Optional<Account.Id> account) {
    this.user = user;
    this.project = project;
    this.change = change;
    this.account = account;
  }

  @Override
  public CurrentUser user() {
    return user;
  }

  @Override
  public Optional<Project.NameKey> project() {
    return project;
  }

  @Override
  public Optional<Change.Id> change() {
    return change;
  }

  @Override
  public Optional<Account.Id> account() {
    return account;
  }

  @Override
  public String toString() {
    return "QuotaRequestContext{"
        + "user=" + user + ", "
        + "project=" + project + ", "
        + "change=" + change + ", "
        + "account=" + account
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QuotaRequestContext) {
      QuotaRequestContext that = (QuotaRequestContext) o;
      return this.user.equals(that.user())
          && this.project.equals(that.project())
          && this.change.equals(that.change())
          && this.account.equals(that.account());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= user.hashCode();
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= change.hashCode();
    h$ *= 1000003;
    h$ ^= account.hashCode();
    return h$;
  }

  @Override
  public QuotaRequestContext.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends QuotaRequestContext.Builder {
    private CurrentUser user;
    private Optional<Project.NameKey> project = Optional.empty();
    private Optional<Change.Id> change = Optional.empty();
    private Optional<Account.Id> account = Optional.empty();
    Builder() {
    }
    private Builder(QuotaRequestContext source) {
      this.user = source.user();
      this.project = source.project();
      this.change = source.change();
      this.account = source.account();
    }
    @Override
    public QuotaRequestContext.Builder user(CurrentUser user) {
      if (user == null) {
        throw new NullPointerException("Null user");
      }
      this.user = user;
      return this;
    }
    @Override
    public QuotaRequestContext.Builder project(Project.NameKey project) {
      this.project = Optional.of(project);
      return this;
    }
    @Override
    public QuotaRequestContext.Builder change(Change.Id change) {
      this.change = Optional.of(change);
      return this;
    }
    @Override
    public QuotaRequestContext.Builder account(Account.Id account) {
      this.account = Optional.of(account);
      return this;
    }
    @Override
    public QuotaRequestContext build() {
      if (this.user == null) {
        String missing = " user";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QuotaRequestContext(
          this.user,
          this.project,
          this.change,
          this.account);
    }
  }

}
