package com.google.gerrit.server.quota;

import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QuotaResponse extends QuotaResponse {

  private final QuotaResponse.Status status;

  private final Optional<Long> availableTokens;

  private final Optional<String> message;

  private AutoValue_QuotaResponse(
      QuotaResponse.Status status,
      Optional<Long> availableTokens,
      Optional<String> message) {
    this.status = status;
    this.availableTokens = availableTokens;
    this.message = message;
  }

  @Override
  public QuotaResponse.Status status() {
    return status;
  }

  @Override
  public Optional<Long> availableTokens() {
    return availableTokens;
  }

  @Override
  public Optional<String> message() {
    return message;
  }

  @Override
  public String toString() {
    return "QuotaResponse{"
        + "status=" + status + ", "
        + "availableTokens=" + availableTokens + ", "
        + "message=" + message
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QuotaResponse) {
      QuotaResponse that = (QuotaResponse) o;
      return this.status.equals(that.status())
          && this.availableTokens.equals(that.availableTokens())
          && this.message.equals(that.message());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= status.hashCode();
    h$ *= 1000003;
    h$ ^= availableTokens.hashCode();
    h$ *= 1000003;
    h$ ^= message.hashCode();
    return h$;
  }

  static final class Builder extends QuotaResponse.Builder {
    private QuotaResponse.Status status;
    private Optional<Long> availableTokens = Optional.empty();
    private Optional<String> message = Optional.empty();
    Builder() {
    }
    @Override
    public QuotaResponse.Builder status(QuotaResponse.Status status) {
      if (status == null) {
        throw new NullPointerException("Null status");
      }
      this.status = status;
      return this;
    }
    @Override
    public QuotaResponse.Builder availableTokens(Long availableTokens) {
      this.availableTokens = Optional.of(availableTokens);
      return this;
    }
    @Override
    public QuotaResponse.Builder message(String message) {
      this.message = Optional.of(message);
      return this;
    }
    @Override
    public QuotaResponse build() {
      if (this.status == null) {
        String missing = " status";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QuotaResponse(
          this.status,
          this.availableTokens,
          this.message);
    }
  }

}
