// Copyright (C) 2016 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.gerrit.server.restapi.change;

import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.RobotCommentResource;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class GetRobotComment implements RestReadView<RobotCommentResource> {

  private final Provider<CommentJson> commentJson;

  @Inject
  GetRobotComment(Provider<CommentJson> commentJson) {
    this.commentJson = commentJson;
  }

  @Override
  public Response<RobotCommentInfo> apply(RobotCommentResource rsrc)
      throws PermissionBackendException {
    return Response.ok(commentJson.get().newRobotCommentFormatter().format(rsrc.getComment()));
  }
}
