package com.google.gerrit.server.submit;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.server.git.CodeReviewCommit;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MergeOp_BranchBatch extends MergeOp.BranchBatch {

  @Nullable
  private final SubmitType submitType;

  private final ImmutableSet<CodeReviewCommit> commits;

  AutoValue_MergeOp_BranchBatch(
      @Nullable SubmitType submitType,
      ImmutableSet<CodeReviewCommit> commits) {
    this.submitType = submitType;
    if (commits == null) {
      throw new NullPointerException("Null commits");
    }
    this.commits = commits;
  }

  @Nullable
  @Override
  SubmitType submitType() {
    return submitType;
  }

  @Override
  ImmutableSet<CodeReviewCommit> commits() {
    return commits;
  }

  @Override
  public String toString() {
    return "BranchBatch{"
        + "submitType=" + submitType + ", "
        + "commits=" + commits
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MergeOp.BranchBatch) {
      MergeOp.BranchBatch that = (MergeOp.BranchBatch) o;
      return (this.submitType == null ? that.submitType() == null : this.submitType.equals(that.submitType()))
          && this.commits.equals(that.commits());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (submitType == null) ? 0 : submitType.hashCode();
    h$ *= 1000003;
    h$ ^= commits.hashCode();
    return h$;
  }

}
