package com.google.gerrit.server.update;

import com.github.rholder.retry.RetryListener;
import com.google.gerrit.common.Nullable;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RetryHelper_Options extends RetryHelper.Options {

  @Nullable
  private final RetryListener listener;

  @Nullable
  private final Duration timeout;

  private final Optional<String> actionName;

  private final Optional<Predicate<Throwable>> retryWithTrace;

  private final Optional<Consumer<String>> onAutoTrace;

  private AutoValue_RetryHelper_Options(
      @Nullable RetryListener listener,
      @Nullable Duration timeout,
      Optional<String> actionName,
      Optional<Predicate<Throwable>> retryWithTrace,
      Optional<Consumer<String>> onAutoTrace) {
    this.listener = listener;
    this.timeout = timeout;
    this.actionName = actionName;
    this.retryWithTrace = retryWithTrace;
    this.onAutoTrace = onAutoTrace;
  }

  @Nullable
  @Override
  RetryListener listener() {
    return listener;
  }

  @Nullable
  @Override
  Duration timeout() {
    return timeout;
  }

  @Override
  Optional<String> actionName() {
    return actionName;
  }

  @Override
  Optional<Predicate<Throwable>> retryWithTrace() {
    return retryWithTrace;
  }

  @Override
  Optional<Consumer<String>> onAutoTrace() {
    return onAutoTrace;
  }

  @Override
  public String toString() {
    return "Options{"
        + "listener=" + listener + ", "
        + "timeout=" + timeout + ", "
        + "actionName=" + actionName + ", "
        + "retryWithTrace=" + retryWithTrace + ", "
        + "onAutoTrace=" + onAutoTrace
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RetryHelper.Options) {
      RetryHelper.Options that = (RetryHelper.Options) o;
      return (this.listener == null ? that.listener() == null : this.listener.equals(that.listener()))
          && (this.timeout == null ? that.timeout() == null : this.timeout.equals(that.timeout()))
          && this.actionName.equals(that.actionName())
          && this.retryWithTrace.equals(that.retryWithTrace())
          && this.onAutoTrace.equals(that.onAutoTrace());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (listener == null) ? 0 : listener.hashCode();
    h$ *= 1000003;
    h$ ^= (timeout == null) ? 0 : timeout.hashCode();
    h$ *= 1000003;
    h$ ^= actionName.hashCode();
    h$ *= 1000003;
    h$ ^= retryWithTrace.hashCode();
    h$ *= 1000003;
    h$ ^= onAutoTrace.hashCode();
    return h$;
  }

  static final class Builder extends RetryHelper.Options.Builder {
    private RetryListener listener;
    private Duration timeout;
    private Optional<String> actionName = Optional.empty();
    private Optional<Predicate<Throwable>> retryWithTrace = Optional.empty();
    private Optional<Consumer<String>> onAutoTrace = Optional.empty();
    Builder() {
    }
    @Override
    public RetryHelper.Options.Builder listener(RetryListener listener) {
      this.listener = listener;
      return this;
    }
    @Override
    public RetryHelper.Options.Builder timeout(Duration timeout) {
      this.timeout = timeout;
      return this;
    }
    @Override
    public RetryHelper.Options.Builder actionName(String actionName) {
      this.actionName = Optional.of(actionName);
      return this;
    }
    @Override
    public RetryHelper.Options.Builder retryWithTrace(Predicate<Throwable> retryWithTrace) {
      this.retryWithTrace = Optional.of(retryWithTrace);
      return this;
    }
    @Override
    public RetryHelper.Options.Builder onAutoTrace(Consumer<String> onAutoTrace) {
      this.onAutoTrace = Optional.of(onAutoTrace);
      return this;
    }
    @Override
    public RetryHelper.Options build() {
      return new AutoValue_RetryHelper_Options(
          this.listener,
          this.timeout,
          this.actionName,
          this.retryWithTrace,
          this.onAutoTrace);
    }
  }

}
