package com.google.gerrit.entities;

import com.google.gerrit.common.Nullable;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $$AutoValue_SubmitRequirementResult extends SubmitRequirementResult {

  private final SubmitRequirement submitRequirement;

  private final Optional<SubmitRequirementExpressionResult> applicabilityExpressionResult;

  private final Optional<SubmitRequirementExpressionResult> submittabilityExpressionResult;

  private final Optional<SubmitRequirementExpressionResult> overrideExpressionResult;

  private final ObjectId patchSetCommitId;

  private final Optional<Boolean> legacy;

  private final Optional<Boolean> forced;

  private final Optional<Boolean> hidden;

  $$AutoValue_SubmitRequirementResult(
      SubmitRequirement submitRequirement,
      Optional<SubmitRequirementExpressionResult> applicabilityExpressionResult,
      Optional<SubmitRequirementExpressionResult> submittabilityExpressionResult,
      Optional<SubmitRequirementExpressionResult> overrideExpressionResult,
      ObjectId patchSetCommitId,
      Optional<Boolean> legacy,
      Optional<Boolean> forced,
      Optional<Boolean> hidden) {
    if (submitRequirement == null) {
      throw new NullPointerException("Null submitRequirement");
    }
    this.submitRequirement = submitRequirement;
    if (applicabilityExpressionResult == null) {
      throw new NullPointerException("Null applicabilityExpressionResult");
    }
    this.applicabilityExpressionResult = applicabilityExpressionResult;
    if (submittabilityExpressionResult == null) {
      throw new NullPointerException("Null submittabilityExpressionResult");
    }
    this.submittabilityExpressionResult = submittabilityExpressionResult;
    if (overrideExpressionResult == null) {
      throw new NullPointerException("Null overrideExpressionResult");
    }
    this.overrideExpressionResult = overrideExpressionResult;
    if (patchSetCommitId == null) {
      throw new NullPointerException("Null patchSetCommitId");
    }
    this.patchSetCommitId = patchSetCommitId;
    if (legacy == null) {
      throw new NullPointerException("Null legacy");
    }
    this.legacy = legacy;
    if (forced == null) {
      throw new NullPointerException("Null forced");
    }
    this.forced = forced;
    if (hidden == null) {
      throw new NullPointerException("Null hidden");
    }
    this.hidden = hidden;
  }

  @Override
  public SubmitRequirement submitRequirement() {
    return submitRequirement;
  }

  @Override
  public Optional<SubmitRequirementExpressionResult> applicabilityExpressionResult() {
    return applicabilityExpressionResult;
  }

  @Override
  public Optional<SubmitRequirementExpressionResult> submittabilityExpressionResult() {
    return submittabilityExpressionResult;
  }

  @Override
  public Optional<SubmitRequirementExpressionResult> overrideExpressionResult() {
    return overrideExpressionResult;
  }

  @Override
  public ObjectId patchSetCommitId() {
    return patchSetCommitId;
  }

  @Override
  public Optional<Boolean> legacy() {
    return legacy;
  }

  @Override
  public Optional<Boolean> forced() {
    return forced;
  }

  @Override
  public Optional<Boolean> hidden() {
    return hidden;
  }

  @Override
  public String toString() {
    return "SubmitRequirementResult{"
        + "submitRequirement=" + submitRequirement + ", "
        + "applicabilityExpressionResult=" + applicabilityExpressionResult + ", "
        + "submittabilityExpressionResult=" + submittabilityExpressionResult + ", "
        + "overrideExpressionResult=" + overrideExpressionResult + ", "
        + "patchSetCommitId=" + patchSetCommitId + ", "
        + "legacy=" + legacy + ", "
        + "forced=" + forced + ", "
        + "hidden=" + hidden
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubmitRequirementResult) {
      SubmitRequirementResult that = (SubmitRequirementResult) o;
      return this.submitRequirement.equals(that.submitRequirement())
          && this.applicabilityExpressionResult.equals(that.applicabilityExpressionResult())
          && this.submittabilityExpressionResult.equals(that.submittabilityExpressionResult())
          && this.overrideExpressionResult.equals(that.overrideExpressionResult())
          && this.patchSetCommitId.equals(that.patchSetCommitId())
          && this.legacy.equals(that.legacy())
          && this.forced.equals(that.forced())
          && this.hidden.equals(that.hidden());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= submitRequirement.hashCode();
    h$ *= 1000003;
    h$ ^= applicabilityExpressionResult.hashCode();
    h$ *= 1000003;
    h$ ^= submittabilityExpressionResult.hashCode();
    h$ *= 1000003;
    h$ ^= overrideExpressionResult.hashCode();
    h$ *= 1000003;
    h$ ^= patchSetCommitId.hashCode();
    h$ *= 1000003;
    h$ ^= legacy.hashCode();
    h$ *= 1000003;
    h$ ^= forced.hashCode();
    h$ *= 1000003;
    h$ ^= hidden.hashCode();
    return h$;
  }

  @Override
  public SubmitRequirementResult.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends SubmitRequirementResult.Builder {
    private SubmitRequirement submitRequirement;
    private Optional<SubmitRequirementExpressionResult> applicabilityExpressionResult = Optional.empty();
    private Optional<SubmitRequirementExpressionResult> submittabilityExpressionResult = Optional.empty();
    private Optional<SubmitRequirementExpressionResult> overrideExpressionResult = Optional.empty();
    private ObjectId patchSetCommitId;
    private Optional<Boolean> legacy = Optional.empty();
    private Optional<Boolean> forced = Optional.empty();
    private Optional<Boolean> hidden = Optional.empty();
    Builder() {
    }
    private Builder(SubmitRequirementResult source) {
      this.submitRequirement = source.submitRequirement();
      this.applicabilityExpressionResult = source.applicabilityExpressionResult();
      this.submittabilityExpressionResult = source.submittabilityExpressionResult();
      this.overrideExpressionResult = source.overrideExpressionResult();
      this.patchSetCommitId = source.patchSetCommitId();
      this.legacy = source.legacy();
      this.forced = source.forced();
      this.hidden = source.hidden();
    }
    @Override
    public SubmitRequirementResult.Builder submitRequirement(SubmitRequirement submitRequirement) {
      if (submitRequirement == null) {
        throw new NullPointerException("Null submitRequirement");
      }
      this.submitRequirement = submitRequirement;
      return this;
    }
    @Override
    public SubmitRequirementResult.Builder applicabilityExpressionResult(Optional<SubmitRequirementExpressionResult> applicabilityExpressionResult) {
      if (applicabilityExpressionResult == null) {
        throw new NullPointerException("Null applicabilityExpressionResult");
      }
      this.applicabilityExpressionResult = applicabilityExpressionResult;
      return this;
    }
    @Override
    public SubmitRequirementResult.Builder submittabilityExpressionResult(Optional<SubmitRequirementExpressionResult> submittabilityExpressionResult) {
      if (submittabilityExpressionResult == null) {
        throw new NullPointerException("Null submittabilityExpressionResult");
      }
      this.submittabilityExpressionResult = submittabilityExpressionResult;
      return this;
    }
    @Override
    public SubmitRequirementResult.Builder submittabilityExpressionResult(@Nullable SubmitRequirementExpressionResult submittabilityExpressionResult) {
      this.submittabilityExpressionResult = Optional.ofNullable(submittabilityExpressionResult);
      return this;
    }
    @Override
    public SubmitRequirementResult.Builder overrideExpressionResult(Optional<SubmitRequirementExpressionResult> overrideExpressionResult) {
      if (overrideExpressionResult == null) {
        throw new NullPointerException("Null overrideExpressionResult");
      }
      this.overrideExpressionResult = overrideExpressionResult;
      return this;
    }
    @Override
    public SubmitRequirementResult.Builder patchSetCommitId(ObjectId patchSetCommitId) {
      if (patchSetCommitId == null) {
        throw new NullPointerException("Null patchSetCommitId");
      }
      this.patchSetCommitId = patchSetCommitId;
      return this;
    }
    @Override
    public SubmitRequirementResult.Builder legacy(Optional<Boolean> legacy) {
      if (legacy == null) {
        throw new NullPointerException("Null legacy");
      }
      this.legacy = legacy;
      return this;
    }
    @Override
    public SubmitRequirementResult.Builder forced(Optional<Boolean> forced) {
      if (forced == null) {
        throw new NullPointerException("Null forced");
      }
      this.forced = forced;
      return this;
    }
    @Override
    public SubmitRequirementResult.Builder hidden(Optional<Boolean> hidden) {
      if (hidden == null) {
        throw new NullPointerException("Null hidden");
      }
      this.hidden = hidden;
      return this;
    }
    @Override
    public SubmitRequirementResult build() {
      String missing = "";
      if (this.submitRequirement == null) {
        missing += " submitRequirement";
      }
      if (this.patchSetCommitId == null) {
        missing += " patchSetCommitId";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubmitRequirementResult(
          this.submitRequirement,
          this.applicabilityExpressionResult,
          this.submittabilityExpressionResult,
          this.overrideExpressionResult,
          this.patchSetCommitId,
          this.legacy,
          this.forced,
          this.hidden);
    }
  }

}
