package com.google.gerrit.entities;

import com.google.common.collect.ImmutableList;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_AccessSection extends AccessSection {

  private final String name;

  private final ImmutableList<Permission> permissions;

  $AutoValue_AccessSection(
      String name,
      ImmutableList<Permission> permissions) {
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    if (permissions == null) {
      throw new NullPointerException("Null permissions");
    }
    this.permissions = permissions;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public ImmutableList<Permission> getPermissions() {
    return permissions;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AccessSection) {
      AccessSection that = (AccessSection) o;
      return this.name.equals(that.getName())
          && this.permissions.equals(that.getPermissions());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= permissions.hashCode();
    return h$;
  }

  @Override
  protected AccessSection.Builder autoToBuilder() {
    return new Builder(this);
  }

  static class Builder extends AccessSection.Builder {
    private String name;
    private ImmutableList<Permission> permissions;
    Builder() {
    }
    private Builder(AccessSection source) {
      this.name = source.getName();
      this.permissions = source.getPermissions();
    }
    @Override
    public AccessSection.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public String getName() {
      if (name == null) {
        throw new IllegalStateException("Property \"name\" has not been set");
      }
      return name;
    }
    @Override
    AccessSection.Builder setPermissions(ImmutableList<Permission> permissions) {
      if (permissions == null) {
        throw new NullPointerException("Null permissions");
      }
      this.permissions = permissions;
      return this;
    }
    @Override
    protected ImmutableList<Permission> getPermissions() {
      if (permissions == null) {
        throw new IllegalStateException("Property \"permissions\" has not been set");
      }
      return permissions;
    }
    @Override
    protected AccessSection autoBuild() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.permissions == null) {
        missing += " permissions";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AccessSection(
          this.name,
          this.permissions);
    }
  }

}
