package com.google.gerrit.entities;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_NotifyConfig extends NotifyConfig {

  private final String name;

  private final ImmutableSet<NotifyConfig.NotifyType> notify;

  private final String filter;

  private final NotifyConfig.Header header;

  private final ImmutableSet<GroupReference> groups;

  private final ImmutableSet<Address> addresses;

  $AutoValue_NotifyConfig(
      String name,
      ImmutableSet<NotifyConfig.NotifyType> notify,
      @Nullable String filter,
      @Nullable NotifyConfig.Header header,
      ImmutableSet<GroupReference> groups,
      ImmutableSet<Address> addresses) {
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    if (notify == null) {
      throw new NullPointerException("Null notify");
    }
    this.notify = notify;
    this.filter = filter;
    this.header = header;
    if (groups == null) {
      throw new NullPointerException("Null groups");
    }
    this.groups = groups;
    if (addresses == null) {
      throw new NullPointerException("Null addresses");
    }
    this.addresses = addresses;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public ImmutableSet<NotifyConfig.NotifyType> getNotify() {
    return notify;
  }

  @Nullable
  @Override
  public String getFilter() {
    return filter;
  }

  @Nullable
  @Override
  public NotifyConfig.Header getHeader() {
    return header;
  }

  @Override
  public ImmutableSet<GroupReference> getGroups() {
    return groups;
  }

  @Override
  public ImmutableSet<Address> getAddresses() {
    return addresses;
  }

  @Override
  public String toString() {
    return "NotifyConfig{"
        + "name=" + name + ", "
        + "notify=" + notify + ", "
        + "filter=" + filter + ", "
        + "header=" + header + ", "
        + "groups=" + groups + ", "
        + "addresses=" + addresses
        + "}";
  }

  static class Builder extends NotifyConfig.Builder {
    private String name;
    private ImmutableSet<NotifyConfig.NotifyType> notify;
    private String filter;
    private NotifyConfig.Header header;
    private ImmutableSet.Builder<GroupReference> groupsBuilder$;
    private ImmutableSet<GroupReference> groups;
    private ImmutableSet.Builder<Address> addressesBuilder$;
    private ImmutableSet<Address> addresses;
    Builder() {
    }
    @Override
    public NotifyConfig.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public NotifyConfig.Builder setNotify(Set<NotifyConfig.NotifyType> notify) {
      this.notify = ImmutableSet.copyOf(notify);
      return this;
    }
    @Override
    public NotifyConfig.Builder setFilter(@Nullable String filter) {
      this.filter = filter;
      return this;
    }
    @Override
    @Nullable protected String getFilter() {
      return filter;
    }
    @Override
    public NotifyConfig.Builder setHeader(NotifyConfig.Header header) {
      this.header = header;
      return this;
    }
    @Override
    protected ImmutableSet.Builder<GroupReference> groupsBuilder() {
      if (groupsBuilder$ == null) {
        groupsBuilder$ = ImmutableSet.builder();
      }
      return groupsBuilder$;
    }
    @Override
    protected ImmutableSet.Builder<Address> addressesBuilder() {
      if (addressesBuilder$ == null) {
        addressesBuilder$ = ImmutableSet.builder();
      }
      return addressesBuilder$;
    }
    @Override
    protected NotifyConfig autoBuild() {
      if (groupsBuilder$ != null) {
        this.groups = groupsBuilder$.build();
      } else if (this.groups == null) {
        this.groups = ImmutableSet.of();
      }
      if (addressesBuilder$ != null) {
        this.addresses = addressesBuilder$.build();
      } else if (this.addresses == null) {
        this.addresses = ImmutableSet.of();
      }
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.notify == null) {
        missing += " notify";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_NotifyConfig(
          this.name,
          this.notify,
          this.filter,
          this.header,
          this.groups,
          this.addresses);
    }
  }

}
