package com.google.gerrit.entities;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AccountGroupByIdAudit extends AccountGroupByIdAudit {

  private final AccountGroup.Id groupId;

  private final AccountGroup.UUID includeUuid;

  private final Account.Id addedBy;

  private final Instant addedOn;

  private final Optional<Account.Id> removedBy;

  private final Optional<Instant> removedOn;

  private AutoValue_AccountGroupByIdAudit(
      AccountGroup.Id groupId,
      AccountGroup.UUID includeUuid,
      Account.Id addedBy,
      Instant addedOn,
      Optional<Account.Id> removedBy,
      Optional<Instant> removedOn) {
    this.groupId = groupId;
    this.includeUuid = includeUuid;
    this.addedBy = addedBy;
    this.addedOn = addedOn;
    this.removedBy = removedBy;
    this.removedOn = removedOn;
  }

  @Override
  public AccountGroup.Id groupId() {
    return groupId;
  }

  @Override
  public AccountGroup.UUID includeUuid() {
    return includeUuid;
  }

  @Override
  public Account.Id addedBy() {
    return addedBy;
  }

  @Override
  public Instant addedOn() {
    return addedOn;
  }

  @Override
  public Optional<Account.Id> removedBy() {
    return removedBy;
  }

  @Override
  public Optional<Instant> removedOn() {
    return removedOn;
  }

  @Override
  public String toString() {
    return "AccountGroupByIdAudit{"
        + "groupId=" + groupId + ", "
        + "includeUuid=" + includeUuid + ", "
        + "addedBy=" + addedBy + ", "
        + "addedOn=" + addedOn + ", "
        + "removedBy=" + removedBy + ", "
        + "removedOn=" + removedOn
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AccountGroupByIdAudit) {
      AccountGroupByIdAudit that = (AccountGroupByIdAudit) o;
      return this.groupId.equals(that.groupId())
          && this.includeUuid.equals(that.includeUuid())
          && this.addedBy.equals(that.addedBy())
          && this.addedOn.equals(that.addedOn())
          && this.removedBy.equals(that.removedBy())
          && this.removedOn.equals(that.removedOn());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= groupId.hashCode();
    h$ *= 1000003;
    h$ ^= includeUuid.hashCode();
    h$ *= 1000003;
    h$ ^= addedBy.hashCode();
    h$ *= 1000003;
    h$ ^= addedOn.hashCode();
    h$ *= 1000003;
    h$ ^= removedBy.hashCode();
    h$ *= 1000003;
    h$ ^= removedOn.hashCode();
    return h$;
  }

  @Override
  public AccountGroupByIdAudit.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AccountGroupByIdAudit.Builder {
    private AccountGroup.Id groupId;
    private AccountGroup.UUID includeUuid;
    private Account.Id addedBy;
    private Instant addedOn;
    private Optional<Account.Id> removedBy = Optional.empty();
    private Optional<Instant> removedOn = Optional.empty();
    Builder() {
    }
    private Builder(AccountGroupByIdAudit source) {
      this.groupId = source.groupId();
      this.includeUuid = source.includeUuid();
      this.addedBy = source.addedBy();
      this.addedOn = source.addedOn();
      this.removedBy = source.removedBy();
      this.removedOn = source.removedOn();
    }
    @Override
    public AccountGroupByIdAudit.Builder groupId(AccountGroup.Id groupId) {
      if (groupId == null) {
        throw new NullPointerException("Null groupId");
      }
      this.groupId = groupId;
      return this;
    }
    @Override
    public AccountGroupByIdAudit.Builder includeUuid(AccountGroup.UUID includeUuid) {
      if (includeUuid == null) {
        throw new NullPointerException("Null includeUuid");
      }
      this.includeUuid = includeUuid;
      return this;
    }
    @Override
    public AccountGroupByIdAudit.Builder addedBy(Account.Id addedBy) {
      if (addedBy == null) {
        throw new NullPointerException("Null addedBy");
      }
      this.addedBy = addedBy;
      return this;
    }
    @Override
    public AccountGroupByIdAudit.Builder addedOn(Instant addedOn) {
      if (addedOn == null) {
        throw new NullPointerException("Null addedOn");
      }
      this.addedOn = addedOn;
      return this;
    }
    @Override
    AccountGroupByIdAudit.Builder removedBy(Account.Id removedBy) {
      this.removedBy = Optional.of(removedBy);
      return this;
    }
    @Override
    AccountGroupByIdAudit.Builder removedOn(Instant removedOn) {
      this.removedOn = Optional.of(removedOn);
      return this;
    }
    @Override
    public AccountGroupByIdAudit build() {
      String missing = "";
      if (this.groupId == null) {
        missing += " groupId";
      }
      if (this.includeUuid == null) {
        missing += " includeUuid";
      }
      if (this.addedBy == null) {
        missing += " addedBy";
      }
      if (this.addedOn == null) {
        missing += " addedOn";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AccountGroupByIdAudit(
          this.groupId,
          this.includeUuid,
          this.addedBy,
          this.addedOn,
          this.removedBy,
          this.removedOn);
    }
  }

}
