package com.google.gerrit.entities;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ContributorAgreement extends ContributorAgreement {

  private final String name;

  private final String description;

  private final ImmutableList<PermissionRule> accepted;

  private final GroupReference autoVerify;

  private final String agreementUrl;

  private final ImmutableList<String> excludeProjectsRegexes;

  private final ImmutableList<String> matchProjectsRegexes;

  private AutoValue_ContributorAgreement(
      String name,
      @Nullable String description,
      ImmutableList<PermissionRule> accepted,
      @Nullable GroupReference autoVerify,
      @Nullable String agreementUrl,
      ImmutableList<String> excludeProjectsRegexes,
      ImmutableList<String> matchProjectsRegexes) {
    this.name = name;
    this.description = description;
    this.accepted = accepted;
    this.autoVerify = autoVerify;
    this.agreementUrl = agreementUrl;
    this.excludeProjectsRegexes = excludeProjectsRegexes;
    this.matchProjectsRegexes = matchProjectsRegexes;
  }

  @Override
  public String getName() {
    return name;
  }

  @Nullable
  @Override
  public String getDescription() {
    return description;
  }

  @Override
  public ImmutableList<PermissionRule> getAccepted() {
    return accepted;
  }

  @Nullable
  @Override
  public GroupReference getAutoVerify() {
    return autoVerify;
  }

  @Nullable
  @Override
  public String getAgreementUrl() {
    return agreementUrl;
  }

  @Override
  public ImmutableList<String> getExcludeProjectsRegexes() {
    return excludeProjectsRegexes;
  }

  @Override
  public ImmutableList<String> getMatchProjectsRegexes() {
    return matchProjectsRegexes;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ContributorAgreement) {
      ContributorAgreement that = (ContributorAgreement) o;
      return this.name.equals(that.getName())
          && (this.description == null ? that.getDescription() == null : this.description.equals(that.getDescription()))
          && this.accepted.equals(that.getAccepted())
          && (this.autoVerify == null ? that.getAutoVerify() == null : this.autoVerify.equals(that.getAutoVerify()))
          && (this.agreementUrl == null ? that.getAgreementUrl() == null : this.agreementUrl.equals(that.getAgreementUrl()))
          && this.excludeProjectsRegexes.equals(that.getExcludeProjectsRegexes())
          && this.matchProjectsRegexes.equals(that.getMatchProjectsRegexes());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= accepted.hashCode();
    h$ *= 1000003;
    h$ ^= (autoVerify == null) ? 0 : autoVerify.hashCode();
    h$ *= 1000003;
    h$ ^= (agreementUrl == null) ? 0 : agreementUrl.hashCode();
    h$ *= 1000003;
    h$ ^= excludeProjectsRegexes.hashCode();
    h$ *= 1000003;
    h$ ^= matchProjectsRegexes.hashCode();
    return h$;
  }

  @Override
  public ContributorAgreement.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ContributorAgreement.Builder {
    private String name;
    private String description;
    private ImmutableList<PermissionRule> accepted;
    private GroupReference autoVerify;
    private String agreementUrl;
    private ImmutableList<String> excludeProjectsRegexes;
    private ImmutableList<String> matchProjectsRegexes;
    Builder() {
    }
    private Builder(ContributorAgreement source) {
      this.name = source.getName();
      this.description = source.getDescription();
      this.accepted = source.getAccepted();
      this.autoVerify = source.getAutoVerify();
      this.agreementUrl = source.getAgreementUrl();
      this.excludeProjectsRegexes = source.getExcludeProjectsRegexes();
      this.matchProjectsRegexes = source.getMatchProjectsRegexes();
    }
    @Override
    public ContributorAgreement.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public ContributorAgreement.Builder setDescription(@Nullable String description) {
      this.description = description;
      return this;
    }
    @Override
    public ContributorAgreement.Builder setAccepted(ImmutableList<PermissionRule> accepted) {
      if (accepted == null) {
        throw new NullPointerException("Null accepted");
      }
      this.accepted = accepted;
      return this;
    }
    @Override
    public ContributorAgreement.Builder setAutoVerify(@Nullable GroupReference autoVerify) {
      this.autoVerify = autoVerify;
      return this;
    }
    @Override
    public ContributorAgreement.Builder setAgreementUrl(@Nullable String agreementUrl) {
      this.agreementUrl = agreementUrl;
      return this;
    }
    @Override
    public ContributorAgreement.Builder setExcludeProjectsRegexes(List<String> excludeProjectsRegexes) {
      this.excludeProjectsRegexes = ImmutableList.copyOf(excludeProjectsRegexes);
      return this;
    }
    @Override
    public ContributorAgreement.Builder setMatchProjectsRegexes(List<String> matchProjectsRegexes) {
      this.matchProjectsRegexes = ImmutableList.copyOf(matchProjectsRegexes);
      return this;
    }
    @Override
    public ContributorAgreement build() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.accepted == null) {
        missing += " accepted";
      }
      if (this.excludeProjectsRegexes == null) {
        missing += " excludeProjectsRegexes";
      }
      if (this.matchProjectsRegexes == null) {
        missing += " matchProjectsRegexes";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ContributorAgreement(
          this.name,
          this.description,
          this.accepted,
          this.autoVerify,
          this.agreementUrl,
          this.excludeProjectsRegexes,
          this.matchProjectsRegexes);
    }
  }

}
