package com.google.gerrit.entities;

import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ParentCommitData extends ParentCommitData {

  private final Optional<String> branchName;

  private final Optional<ObjectId> commitId;

  private final Boolean isMergedInTargetBranch;

  private final Optional<Change.Key> changeKey;

  private final Optional<Integer> changeNumber;

  private final Optional<Integer> patchSetNumber;

  private final Optional<Change.Status> changeStatus;

  private AutoValue_ParentCommitData(
      Optional<String> branchName,
      Optional<ObjectId> commitId,
      Boolean isMergedInTargetBranch,
      Optional<Change.Key> changeKey,
      Optional<Integer> changeNumber,
      Optional<Integer> patchSetNumber,
      Optional<Change.Status> changeStatus) {
    this.branchName = branchName;
    this.commitId = commitId;
    this.isMergedInTargetBranch = isMergedInTargetBranch;
    this.changeKey = changeKey;
    this.changeNumber = changeNumber;
    this.patchSetNumber = patchSetNumber;
    this.changeStatus = changeStatus;
  }

  @Override
  public Optional<String> branchName() {
    return branchName;
  }

  @Override
  public Optional<ObjectId> commitId() {
    return commitId;
  }

  @Override
  public Boolean isMergedInTargetBranch() {
    return isMergedInTargetBranch;
  }

  @Override
  public Optional<Change.Key> changeKey() {
    return changeKey;
  }

  @Override
  public Optional<Integer> changeNumber() {
    return changeNumber;
  }

  @Override
  public Optional<Integer> patchSetNumber() {
    return patchSetNumber;
  }

  @Override
  public Optional<Change.Status> changeStatus() {
    return changeStatus;
  }

  @Override
  public String toString() {
    return "ParentCommitData{"
        + "branchName=" + branchName + ", "
        + "commitId=" + commitId + ", "
        + "isMergedInTargetBranch=" + isMergedInTargetBranch + ", "
        + "changeKey=" + changeKey + ", "
        + "changeNumber=" + changeNumber + ", "
        + "patchSetNumber=" + patchSetNumber + ", "
        + "changeStatus=" + changeStatus
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ParentCommitData) {
      ParentCommitData that = (ParentCommitData) o;
      return this.branchName.equals(that.branchName())
          && this.commitId.equals(that.commitId())
          && this.isMergedInTargetBranch.equals(that.isMergedInTargetBranch())
          && this.changeKey.equals(that.changeKey())
          && this.changeNumber.equals(that.changeNumber())
          && this.patchSetNumber.equals(that.patchSetNumber())
          && this.changeStatus.equals(that.changeStatus());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= branchName.hashCode();
    h$ *= 1000003;
    h$ ^= commitId.hashCode();
    h$ *= 1000003;
    h$ ^= isMergedInTargetBranch.hashCode();
    h$ *= 1000003;
    h$ ^= changeKey.hashCode();
    h$ *= 1000003;
    h$ ^= changeNumber.hashCode();
    h$ *= 1000003;
    h$ ^= patchSetNumber.hashCode();
    h$ *= 1000003;
    h$ ^= changeStatus.hashCode();
    return h$;
  }

  @Override
  public ParentCommitData.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ParentCommitData.Builder {
    private Optional<String> branchName = Optional.empty();
    private Optional<ObjectId> commitId = Optional.empty();
    private Boolean isMergedInTargetBranch;
    private Optional<Change.Key> changeKey = Optional.empty();
    private Optional<Integer> changeNumber = Optional.empty();
    private Optional<Integer> patchSetNumber = Optional.empty();
    private Optional<Change.Status> changeStatus = Optional.empty();
    Builder() {
    }
    private Builder(ParentCommitData source) {
      this.branchName = source.branchName();
      this.commitId = source.commitId();
      this.isMergedInTargetBranch = source.isMergedInTargetBranch();
      this.changeKey = source.changeKey();
      this.changeNumber = source.changeNumber();
      this.patchSetNumber = source.patchSetNumber();
      this.changeStatus = source.changeStatus();
    }
    @Override
    public ParentCommitData.Builder branchName(Optional<String> branchName) {
      if (branchName == null) {
        throw new NullPointerException("Null branchName");
      }
      this.branchName = branchName;
      return this;
    }
    @Override
    public ParentCommitData.Builder commitId(Optional<ObjectId> commitId) {
      if (commitId == null) {
        throw new NullPointerException("Null commitId");
      }
      this.commitId = commitId;
      return this;
    }
    @Override
    public ParentCommitData.Builder isMergedInTargetBranch(Boolean isMergedInTargetBranch) {
      if (isMergedInTargetBranch == null) {
        throw new NullPointerException("Null isMergedInTargetBranch");
      }
      this.isMergedInTargetBranch = isMergedInTargetBranch;
      return this;
    }
    @Override
    public ParentCommitData.Builder changeKey(Optional<Change.Key> changeKey) {
      if (changeKey == null) {
        throw new NullPointerException("Null changeKey");
      }
      this.changeKey = changeKey;
      return this;
    }
    @Override
    public ParentCommitData.Builder changeNumber(Optional<Integer> changeNumber) {
      if (changeNumber == null) {
        throw new NullPointerException("Null changeNumber");
      }
      this.changeNumber = changeNumber;
      return this;
    }
    @Override
    public ParentCommitData.Builder patchSetNumber(Optional<Integer> patchSetNumber) {
      if (patchSetNumber == null) {
        throw new NullPointerException("Null patchSetNumber");
      }
      this.patchSetNumber = patchSetNumber;
      return this;
    }
    @Override
    public ParentCommitData.Builder changeStatus(Optional<Change.Status> changeStatus) {
      if (changeStatus == null) {
        throw new NullPointerException("Null changeStatus");
      }
      this.changeStatus = changeStatus;
      return this;
    }
    @Override
    public ParentCommitData autoBuild() {
      String missing = "";
      if (this.isMergedInTargetBranch == null) {
        missing += " isMergedInTargetBranch";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ParentCommitData(
          this.branchName,
          this.commitId,
          this.isMergedInTargetBranch,
          this.changeKey,
          this.changeNumber,
          this.patchSetNumber,
          this.changeStatus);
    }
  }

}
