package com.google.gerrit.entities;

import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PatchSet extends PatchSet {

  private final PatchSet.Id id;

  private final ObjectId commitId;

  private final Optional<String> branch;

  private final Account.Id uploader;

  private final Account.Id realUploader;

  private final Instant createdOn;

  private final ImmutableList<String> groups;

  private final Optional<String> pushCertificate;

  private final Optional<String> description;

  private AutoValue_PatchSet(
      PatchSet.Id id,
      ObjectId commitId,
      Optional<String> branch,
      Account.Id uploader,
      Account.Id realUploader,
      Instant createdOn,
      ImmutableList<String> groups,
      Optional<String> pushCertificate,
      Optional<String> description) {
    this.id = id;
    this.commitId = commitId;
    this.branch = branch;
    this.uploader = uploader;
    this.realUploader = realUploader;
    this.createdOn = createdOn;
    this.groups = groups;
    this.pushCertificate = pushCertificate;
    this.description = description;
  }

  @Override
  public PatchSet.Id id() {
    return id;
  }

  @Override
  public ObjectId commitId() {
    return commitId;
  }

  @Override
  public Optional<String> branch() {
    return branch;
  }

  @Override
  public Account.Id uploader() {
    return uploader;
  }

  @Override
  public Account.Id realUploader() {
    return realUploader;
  }

  @Override
  public Instant createdOn() {
    return createdOn;
  }

  @Override
  public ImmutableList<String> groups() {
    return groups;
  }

  @Override
  public Optional<String> pushCertificate() {
    return pushCertificate;
  }

  @Override
  public Optional<String> description() {
    return description;
  }

  @Override
  public String toString() {
    return "PatchSet{"
        + "id=" + id + ", "
        + "commitId=" + commitId + ", "
        + "branch=" + branch + ", "
        + "uploader=" + uploader + ", "
        + "realUploader=" + realUploader + ", "
        + "createdOn=" + createdOn + ", "
        + "groups=" + groups + ", "
        + "pushCertificate=" + pushCertificate + ", "
        + "description=" + description
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PatchSet) {
      PatchSet that = (PatchSet) o;
      return this.id.equals(that.id())
          && this.commitId.equals(that.commitId())
          && this.branch.equals(that.branch())
          && this.uploader.equals(that.uploader())
          && this.realUploader.equals(that.realUploader())
          && this.createdOn.equals(that.createdOn())
          && this.groups.equals(that.groups())
          && this.pushCertificate.equals(that.pushCertificate())
          && this.description.equals(that.description());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= commitId.hashCode();
    h$ *= 1000003;
    h$ ^= branch.hashCode();
    h$ *= 1000003;
    h$ ^= uploader.hashCode();
    h$ *= 1000003;
    h$ ^= realUploader.hashCode();
    h$ *= 1000003;
    h$ ^= createdOn.hashCode();
    h$ *= 1000003;
    h$ ^= groups.hashCode();
    h$ *= 1000003;
    h$ ^= pushCertificate.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    return h$;
  }

  static final class Builder extends PatchSet.Builder {
    private PatchSet.Id id;
    private ObjectId commitId;
    private Optional<String> branch = Optional.empty();
    private Account.Id uploader;
    private Account.Id realUploader;
    private Instant createdOn;
    private ImmutableList<String> groups;
    private Optional<String> pushCertificate = Optional.empty();
    private Optional<String> description = Optional.empty();
    Builder() {
    }
    @Override
    public PatchSet.Builder id(PatchSet.Id id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public PatchSet.Id id() {
      if (id == null) {
        throw new IllegalStateException("Property \"id\" has not been set");
      }
      return id;
    }
    @Override
    public PatchSet.Builder commitId(ObjectId commitId) {
      if (commitId == null) {
        throw new NullPointerException("Null commitId");
      }
      this.commitId = commitId;
      return this;
    }
    @Override
    public Optional<ObjectId> commitId() {
      if (commitId == null) {
        return Optional.empty();
      } else {
        return Optional.of(commitId);
      }
    }
    @Override
    public PatchSet.Builder branch(Optional<String> branch) {
      if (branch == null) {
        throw new NullPointerException("Null branch");
      }
      this.branch = branch;
      return this;
    }
    @Override
    public PatchSet.Builder branch(String branch) {
      this.branch = Optional.of(branch);
      return this;
    }
    @Override
    public PatchSet.Builder uploader(Account.Id uploader) {
      if (uploader == null) {
        throw new NullPointerException("Null uploader");
      }
      this.uploader = uploader;
      return this;
    }
    @Override
    public PatchSet.Builder realUploader(Account.Id realUploader) {
      if (realUploader == null) {
        throw new NullPointerException("Null realUploader");
      }
      this.realUploader = realUploader;
      return this;
    }
    @Override
    public PatchSet.Builder createdOn(Instant createdOn) {
      if (createdOn == null) {
        throw new NullPointerException("Null createdOn");
      }
      this.createdOn = createdOn;
      return this;
    }
    @Override
    public PatchSet.Builder groups(Iterable<String> groups) {
      this.groups = ImmutableList.copyOf(groups);
      return this;
    }
    @Override
    public ImmutableList<String> groups() {
      if (groups == null) {
        throw new IllegalStateException("Property \"groups\" has not been set");
      }
      return groups;
    }
    @Override
    public PatchSet.Builder pushCertificate(Optional<String> pushCertificate) {
      if (pushCertificate == null) {
        throw new NullPointerException("Null pushCertificate");
      }
      this.pushCertificate = pushCertificate;
      return this;
    }
    @Override
    public PatchSet.Builder pushCertificate(String pushCertificate) {
      this.pushCertificate = Optional.of(pushCertificate);
      return this;
    }
    @Override
    public PatchSet.Builder description(Optional<String> description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public PatchSet.Builder description(String description) {
      this.description = Optional.of(description);
      return this;
    }
    @Override
    public Optional<String> description() {
      return description;
    }
    @Override
    public PatchSet build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.commitId == null) {
        missing += " commitId";
      }
      if (this.uploader == null) {
        missing += " uploader";
      }
      if (this.realUploader == null) {
        missing += " realUploader";
      }
      if (this.createdOn == null) {
        missing += " createdOn";
      }
      if (this.groups == null) {
        missing += " groups";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PatchSet(
          this.id,
          this.commitId,
          this.branch,
          this.uploader,
          this.realUploader,
          this.createdOn,
          this.groups,
          this.pushCertificate,
          this.description);
    }
  }

}
