package com.google.gerrit.entities;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PermissionRule extends PermissionRule {

  private final PermissionRule.Action action;

  private final boolean force;

  private final int min;

  private final int max;

  private final GroupReference group;

  private AutoValue_PermissionRule(
      PermissionRule.Action action,
      boolean force,
      int min,
      int max,
      GroupReference group) {
    this.action = action;
    this.force = force;
    this.min = min;
    this.max = max;
    this.group = group;
  }

  @Override
  public PermissionRule.Action getAction() {
    return action;
  }

  @Override
  public boolean getForce() {
    return force;
  }

  @Override
  public int getMin() {
    return min;
  }

  @Override
  public int getMax() {
    return max;
  }

  @Override
  public GroupReference getGroup() {
    return group;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PermissionRule) {
      PermissionRule that = (PermissionRule) o;
      return this.action.equals(that.getAction())
          && this.force == that.getForce()
          && this.min == that.getMin()
          && this.max == that.getMax()
          && this.group.equals(that.getGroup());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= action.hashCode();
    h$ *= 1000003;
    h$ ^= force ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= min;
    h$ *= 1000003;
    h$ ^= max;
    h$ *= 1000003;
    h$ ^= group.hashCode();
    return h$;
  }

  @Override
  public PermissionRule.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends PermissionRule.Builder {
    private PermissionRule.Action action;
    private Boolean force;
    private Integer min;
    private Integer max;
    private GroupReference group;
    Builder() {
    }
    private Builder(PermissionRule source) {
      this.action = source.getAction();
      this.force = source.getForce();
      this.min = source.getMin();
      this.max = source.getMax();
      this.group = source.getGroup();
    }
    @Override
    public PermissionRule.Builder setAction(PermissionRule.Action action) {
      if (action == null) {
        throw new NullPointerException("Null action");
      }
      this.action = action;
      return this;
    }
    @Override
    public PermissionRule.Builder setForce(boolean force) {
      this.force = force;
      return this;
    }
    @Override
    public PermissionRule.Builder setMin(int min) {
      this.min = min;
      return this;
    }
    @Override
    public PermissionRule.Builder setMax(int max) {
      this.max = max;
      return this;
    }
    @Override
    public PermissionRule.Builder setGroup(GroupReference group) {
      if (group == null) {
        throw new NullPointerException("Null group");
      }
      this.group = group;
      return this;
    }
    @Override
    public GroupReference getGroup() {
      if (group == null) {
        throw new IllegalStateException("Property \"group\" has not been set");
      }
      return group;
    }
    @Override
    public PermissionRule build() {
      String missing = "";
      if (this.action == null) {
        missing += " action";
      }
      if (this.force == null) {
        missing += " force";
      }
      if (this.min == null) {
        missing += " min";
      }
      if (this.max == null) {
        missing += " max";
      }
      if (this.group == null) {
        missing += " group";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PermissionRule(
          this.action,
          this.force,
          this.min,
          this.max,
          this.group);
    }
  }

}
