package com.google.gerrit.entities;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.client.InheritableBoolean;
import com.google.gerrit.extensions.client.ProjectState;
import com.google.gerrit.extensions.client.SubmitType;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Project extends Project {

  private final Project.NameKey nameKey;

  private final String description;

  private final ImmutableMap<BooleanProjectConfig, InheritableBoolean> booleanConfigs;

  private final SubmitType submitType;

  private final ProjectState state;

  private final Project.NameKey parent;

  private final String maxObjectSizeLimit;

  private final String defaultDashboard;

  private final String localDefaultDashboard;

  private final String configRefState;

  private AutoValue_Project(
      Project.NameKey nameKey,
      @Nullable String description,
      ImmutableMap<BooleanProjectConfig, InheritableBoolean> booleanConfigs,
      SubmitType submitType,
      ProjectState state,
      @Nullable Project.NameKey parent,
      @Nullable String maxObjectSizeLimit,
      @Nullable String defaultDashboard,
      @Nullable String localDefaultDashboard,
      @Nullable String configRefState) {
    this.nameKey = nameKey;
    this.description = description;
    this.booleanConfigs = booleanConfigs;
    this.submitType = submitType;
    this.state = state;
    this.parent = parent;
    this.maxObjectSizeLimit = maxObjectSizeLimit;
    this.defaultDashboard = defaultDashboard;
    this.localDefaultDashboard = localDefaultDashboard;
    this.configRefState = configRefState;
  }

  @Override
  public Project.NameKey getNameKey() {
    return nameKey;
  }

  @Nullable
  @Override
  public String getDescription() {
    return description;
  }

  @Override
  public ImmutableMap<BooleanProjectConfig, InheritableBoolean> getBooleanConfigs() {
    return booleanConfigs;
  }

  @Override
  public SubmitType getSubmitType() {
    return submitType;
  }

  @Override
  public ProjectState getState() {
    return state;
  }

  @Nullable
  @Override
  public Project.NameKey getParent() {
    return parent;
  }

  @Nullable
  @Override
  public String getMaxObjectSizeLimit() {
    return maxObjectSizeLimit;
  }

  @Nullable
  @Override
  public String getDefaultDashboard() {
    return defaultDashboard;
  }

  @Nullable
  @Override
  public String getLocalDefaultDashboard() {
    return localDefaultDashboard;
  }

  @Nullable
  @Override
  public String getConfigRefState() {
    return configRefState;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Project) {
      Project that = (Project) o;
      return this.nameKey.equals(that.getNameKey())
          && (this.description == null ? that.getDescription() == null : this.description.equals(that.getDescription()))
          && this.booleanConfigs.equals(that.getBooleanConfigs())
          && this.submitType.equals(that.getSubmitType())
          && this.state.equals(that.getState())
          && (this.parent == null ? that.getParent() == null : this.parent.equals(that.getParent()))
          && (this.maxObjectSizeLimit == null ? that.getMaxObjectSizeLimit() == null : this.maxObjectSizeLimit.equals(that.getMaxObjectSizeLimit()))
          && (this.defaultDashboard == null ? that.getDefaultDashboard() == null : this.defaultDashboard.equals(that.getDefaultDashboard()))
          && (this.localDefaultDashboard == null ? that.getLocalDefaultDashboard() == null : this.localDefaultDashboard.equals(that.getLocalDefaultDashboard()))
          && (this.configRefState == null ? that.getConfigRefState() == null : this.configRefState.equals(that.getConfigRefState()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= nameKey.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= booleanConfigs.hashCode();
    h$ *= 1000003;
    h$ ^= submitType.hashCode();
    h$ *= 1000003;
    h$ ^= state.hashCode();
    h$ *= 1000003;
    h$ ^= (parent == null) ? 0 : parent.hashCode();
    h$ *= 1000003;
    h$ ^= (maxObjectSizeLimit == null) ? 0 : maxObjectSizeLimit.hashCode();
    h$ *= 1000003;
    h$ ^= (defaultDashboard == null) ? 0 : defaultDashboard.hashCode();
    h$ *= 1000003;
    h$ ^= (localDefaultDashboard == null) ? 0 : localDefaultDashboard.hashCode();
    h$ *= 1000003;
    h$ ^= (configRefState == null) ? 0 : configRefState.hashCode();
    return h$;
  }

  @Override
  public Project.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Project.Builder {
    private Project.NameKey nameKey;
    private String description;
    private ImmutableMap<BooleanProjectConfig, InheritableBoolean> booleanConfigs;
    private SubmitType submitType;
    private ProjectState state;
    private Project.NameKey parent;
    private String maxObjectSizeLimit;
    private String defaultDashboard;
    private String localDefaultDashboard;
    private String configRefState;
    Builder() {
    }
    private Builder(Project source) {
      this.nameKey = source.getNameKey();
      this.description = source.getDescription();
      this.booleanConfigs = source.getBooleanConfigs();
      this.submitType = source.getSubmitType();
      this.state = source.getState();
      this.parent = source.getParent();
      this.maxObjectSizeLimit = source.getMaxObjectSizeLimit();
      this.defaultDashboard = source.getDefaultDashboard();
      this.localDefaultDashboard = source.getLocalDefaultDashboard();
      this.configRefState = source.getConfigRefState();
    }
    @Override
    protected Project.Builder setNameKey(Project.NameKey nameKey) {
      if (nameKey == null) {
        throw new NullPointerException("Null nameKey");
      }
      this.nameKey = nameKey;
      return this;
    }
    @Override
    public Project.Builder setDescription(String description) {
      this.description = description;
      return this;
    }
    @Override
    protected Project.Builder setBooleanConfigs(ImmutableMap<BooleanProjectConfig, InheritableBoolean> booleanConfigs) {
      if (booleanConfigs == null) {
        throw new NullPointerException("Null booleanConfigs");
      }
      this.booleanConfigs = booleanConfigs;
      return this;
    }
    @Override
    protected ImmutableMap<BooleanProjectConfig, InheritableBoolean> getBooleanConfigs() {
      if (booleanConfigs == null) {
        throw new IllegalStateException("Property \"booleanConfigs\" has not been set");
      }
      return booleanConfigs;
    }
    @Override
    public Project.Builder setSubmitType(SubmitType submitType) {
      if (submitType == null) {
        throw new NullPointerException("Null submitType");
      }
      this.submitType = submitType;
      return this;
    }
    @Override
    public Project.Builder setState(ProjectState state) {
      if (state == null) {
        throw new NullPointerException("Null state");
      }
      this.state = state;
      return this;
    }
    @Override
    public Project.Builder setParent(Project.NameKey parent) {
      this.parent = parent;
      return this;
    }
    @Override
    public Project.Builder setMaxObjectSizeLimit(String maxObjectSizeLimit) {
      this.maxObjectSizeLimit = maxObjectSizeLimit;
      return this;
    }
    @Override
    public Project.Builder setDefaultDashboard(String defaultDashboard) {
      this.defaultDashboard = defaultDashboard;
      return this;
    }
    @Override
    public Project.Builder setLocalDefaultDashboard(String localDefaultDashboard) {
      this.localDefaultDashboard = localDefaultDashboard;
      return this;
    }
    @Override
    public Project.Builder setConfigRefState(String configRefState) {
      this.configRefState = configRefState;
      return this;
    }
    @Override
    public Project build() {
      String missing = "";
      if (this.nameKey == null) {
        missing += " nameKey";
      }
      if (this.booleanConfigs == null) {
        missing += " booleanConfigs";
      }
      if (this.submitType == null) {
        missing += " submitType";
      }
      if (this.state == null) {
        missing += " state";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Project(
          this.nameKey,
          this.description,
          this.booleanConfigs,
          this.submitType,
          this.state,
          this.parent,
          this.maxObjectSizeLimit,
          this.defaultDashboard,
          this.localDefaultDashboard,
          this.configRefState);
    }
  }

}
