package com.google.gerrit.httpd.restapi;

import com.google.common.collect.ImmutableListMultimap;
import com.google.gerrit.common.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ParameterParser_QueryParams extends ParameterParser.QueryParams {

  private final String accessToken;

  private final String xdMethod;

  private final String xdContentType;

  private final ImmutableListMultimap<String, String> config;

  private final ImmutableListMultimap<String, String> params;

  AutoValue_ParameterParser_QueryParams(
      @Nullable String accessToken,
      @Nullable String xdMethod,
      @Nullable String xdContentType,
      ImmutableListMultimap<String, String> config,
      ImmutableListMultimap<String, String> params) {
    this.accessToken = accessToken;
    this.xdMethod = xdMethod;
    this.xdContentType = xdContentType;
    if (config == null) {
      throw new NullPointerException("Null config");
    }
    this.config = config;
    if (params == null) {
      throw new NullPointerException("Null params");
    }
    this.params = params;
  }

  @Nullable
  @Override
  public String accessToken() {
    return accessToken;
  }

  @Nullable
  @Override
  String xdMethod() {
    return xdMethod;
  }

  @Nullable
  @Override
  String xdContentType() {
    return xdContentType;
  }

  @Override
  ImmutableListMultimap<String, String> config() {
    return config;
  }

  @Override
  ImmutableListMultimap<String, String> params() {
    return params;
  }

  @Override
  public String toString() {
    return "QueryParams{"
        + "accessToken=" + accessToken + ", "
        + "xdMethod=" + xdMethod + ", "
        + "xdContentType=" + xdContentType + ", "
        + "config=" + config + ", "
        + "params=" + params
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ParameterParser.QueryParams) {
      ParameterParser.QueryParams that = (ParameterParser.QueryParams) o;
      return (this.accessToken == null ? that.accessToken() == null : this.accessToken.equals(that.accessToken()))
          && (this.xdMethod == null ? that.xdMethod() == null : this.xdMethod.equals(that.xdMethod()))
          && (this.xdContentType == null ? that.xdContentType() == null : this.xdContentType.equals(that.xdContentType()))
          && this.config.equals(that.config())
          && this.params.equals(that.params());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (accessToken == null) ? 0 : accessToken.hashCode();
    h$ *= 1000003;
    h$ ^= (xdMethod == null) ? 0 : xdMethod.hashCode();
    h$ *= 1000003;
    h$ ^= (xdContentType == null) ? 0 : xdContentType.hashCode();
    h$ *= 1000003;
    h$ ^= config.hashCode();
    h$ *= 1000003;
    h$ ^= params.hashCode();
    return h$;
  }

}
