package com.google.gerrit.index;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_IndexConfig extends IndexConfig {

  private final int defaultLimit;

  private final int maxLimit;

  private final int maxPages;

  private final int maxTerms;

  private final String type;

  private final boolean separateChangeSubIndexes;

  private final PaginationType paginationType;

  private final int pageSizeMultiplier;

  private final int maxPageSize;

  private AutoValue_IndexConfig(
      int defaultLimit,
      int maxLimit,
      int maxPages,
      int maxTerms,
      String type,
      boolean separateChangeSubIndexes,
      PaginationType paginationType,
      int pageSizeMultiplier,
      int maxPageSize) {
    this.defaultLimit = defaultLimit;
    this.maxLimit = maxLimit;
    this.maxPages = maxPages;
    this.maxTerms = maxTerms;
    this.type = type;
    this.separateChangeSubIndexes = separateChangeSubIndexes;
    this.paginationType = paginationType;
    this.pageSizeMultiplier = pageSizeMultiplier;
    this.maxPageSize = maxPageSize;
  }

  @Override
  public int defaultLimit() {
    return defaultLimit;
  }

  @Override
  public int maxLimit() {
    return maxLimit;
  }

  @Override
  public int maxPages() {
    return maxPages;
  }

  @Override
  public int maxTerms() {
    return maxTerms;
  }

  @Override
  public String type() {
    return type;
  }

  @Override
  public boolean separateChangeSubIndexes() {
    return separateChangeSubIndexes;
  }

  @Override
  public PaginationType paginationType() {
    return paginationType;
  }

  @Override
  public int pageSizeMultiplier() {
    return pageSizeMultiplier;
  }

  @Override
  public int maxPageSize() {
    return maxPageSize;
  }

  @Override
  public String toString() {
    return "IndexConfig{"
        + "defaultLimit=" + defaultLimit + ", "
        + "maxLimit=" + maxLimit + ", "
        + "maxPages=" + maxPages + ", "
        + "maxTerms=" + maxTerms + ", "
        + "type=" + type + ", "
        + "separateChangeSubIndexes=" + separateChangeSubIndexes + ", "
        + "paginationType=" + paginationType + ", "
        + "pageSizeMultiplier=" + pageSizeMultiplier + ", "
        + "maxPageSize=" + maxPageSize
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IndexConfig) {
      IndexConfig that = (IndexConfig) o;
      return this.defaultLimit == that.defaultLimit()
          && this.maxLimit == that.maxLimit()
          && this.maxPages == that.maxPages()
          && this.maxTerms == that.maxTerms()
          && this.type.equals(that.type())
          && this.separateChangeSubIndexes == that.separateChangeSubIndexes()
          && this.paginationType.equals(that.paginationType())
          && this.pageSizeMultiplier == that.pageSizeMultiplier()
          && this.maxPageSize == that.maxPageSize();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= defaultLimit;
    h$ *= 1000003;
    h$ ^= maxLimit;
    h$ *= 1000003;
    h$ ^= maxPages;
    h$ *= 1000003;
    h$ ^= maxTerms;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= separateChangeSubIndexes ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= paginationType.hashCode();
    h$ *= 1000003;
    h$ ^= pageSizeMultiplier;
    h$ *= 1000003;
    h$ ^= maxPageSize;
    return h$;
  }

  static final class Builder extends IndexConfig.Builder {
    private Integer defaultLimit;
    private Integer maxLimit;
    private Integer maxPages;
    private Integer maxTerms;
    private String type;
    private Boolean separateChangeSubIndexes;
    private PaginationType paginationType;
    private Integer pageSizeMultiplier;
    private Integer maxPageSize;
    Builder() {
    }
    @Override
    public IndexConfig.Builder defaultLimit(int defaultLimit) {
      this.defaultLimit = defaultLimit;
      return this;
    }
    @Override
    public int defaultLimit() {
      if (defaultLimit == null) {
        throw new IllegalStateException("Property \"defaultLimit\" has not been set");
      }
      return defaultLimit;
    }
    @Override
    public IndexConfig.Builder maxLimit(int maxLimit) {
      this.maxLimit = maxLimit;
      return this;
    }
    @Override
    public int maxLimit() {
      if (maxLimit == null) {
        throw new IllegalStateException("Property \"maxLimit\" has not been set");
      }
      return maxLimit;
    }
    @Override
    public IndexConfig.Builder maxPages(int maxPages) {
      this.maxPages = maxPages;
      return this;
    }
    @Override
    public int maxPages() {
      if (maxPages == null) {
        throw new IllegalStateException("Property \"maxPages\" has not been set");
      }
      return maxPages;
    }
    @Override
    public IndexConfig.Builder maxTerms(int maxTerms) {
      this.maxTerms = maxTerms;
      return this;
    }
    @Override
    public int maxTerms() {
      if (maxTerms == null) {
        throw new IllegalStateException("Property \"maxTerms\" has not been set");
      }
      return maxTerms;
    }
    @Override
    public IndexConfig.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public String type() {
      if (type == null) {
        throw new IllegalStateException("Property \"type\" has not been set");
      }
      return type;
    }
    @Override
    public IndexConfig.Builder separateChangeSubIndexes(boolean separateChangeSubIndexes) {
      this.separateChangeSubIndexes = separateChangeSubIndexes;
      return this;
    }
    @Override
    public IndexConfig.Builder paginationType(PaginationType paginationType) {
      if (paginationType == null) {
        throw new NullPointerException("Null paginationType");
      }
      this.paginationType = paginationType;
      return this;
    }
    @Override
    public IndexConfig.Builder pageSizeMultiplier(int pageSizeMultiplier) {
      this.pageSizeMultiplier = pageSizeMultiplier;
      return this;
    }
    @Override
    public IndexConfig.Builder maxPageSize(int maxPageSize) {
      this.maxPageSize = maxPageSize;
      return this;
    }
    @Override
    IndexConfig autoBuild() {
      String missing = "";
      if (this.defaultLimit == null) {
        missing += " defaultLimit";
      }
      if (this.maxLimit == null) {
        missing += " maxLimit";
      }
      if (this.maxPages == null) {
        missing += " maxPages";
      }
      if (this.maxTerms == null) {
        missing += " maxTerms";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (this.separateChangeSubIndexes == null) {
        missing += " separateChangeSubIndexes";
      }
      if (this.paginationType == null) {
        missing += " paginationType";
      }
      if (this.pageSizeMultiplier == null) {
        missing += " pageSizeMultiplier";
      }
      if (this.maxPageSize == null) {
        missing += " maxPageSize";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_IndexConfig(
          this.defaultLimit,
          this.maxLimit,
          this.maxPages,
          this.maxTerms,
          this.type,
          this.separateChangeSubIndexes,
          this.paginationType,
          this.pageSizeMultiplier,
          this.maxPageSize);
    }
  }

}
