package com.google.gerrit.server;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.entities.Account;
import java.util.regex.Pattern;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.Config;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RequestConfig extends RequestConfig {

  private final Config cfg;

  private final String section;

  private final String id;

  private final ImmutableSet<String> requestTypes;

  private final ImmutableSet<Pattern> requestUriPatterns;

  private final ImmutableSet<Pattern> excludedRequestUriPatterns;

  private final ImmutableSet<Pattern> requestQueryStringPatterns;

  private final ImmutableSet<Pattern> headerPatterns;

  private final ImmutableSet<Account.Id> accountIds;

  private final ImmutableSet<Pattern> projectPatterns;

  private AutoValue_RequestConfig(
      Config cfg,
      String section,
      String id,
      ImmutableSet<String> requestTypes,
      ImmutableSet<Pattern> requestUriPatterns,
      ImmutableSet<Pattern> excludedRequestUriPatterns,
      ImmutableSet<Pattern> requestQueryStringPatterns,
      ImmutableSet<Pattern> headerPatterns,
      ImmutableSet<Account.Id> accountIds,
      ImmutableSet<Pattern> projectPatterns) {
    this.cfg = cfg;
    this.section = section;
    this.id = id;
    this.requestTypes = requestTypes;
    this.requestUriPatterns = requestUriPatterns;
    this.excludedRequestUriPatterns = excludedRequestUriPatterns;
    this.requestQueryStringPatterns = requestQueryStringPatterns;
    this.headerPatterns = headerPatterns;
    this.accountIds = accountIds;
    this.projectPatterns = projectPatterns;
  }

  @Override
  Config cfg() {
    return cfg;
  }

  @Override
  String section() {
    return section;
  }

  @Override
  String id() {
    return id;
  }

  @Override
  ImmutableSet<String> requestTypes() {
    return requestTypes;
  }

  @Override
  ImmutableSet<Pattern> requestUriPatterns() {
    return requestUriPatterns;
  }

  @Override
  ImmutableSet<Pattern> excludedRequestUriPatterns() {
    return excludedRequestUriPatterns;
  }

  @Override
  ImmutableSet<Pattern> requestQueryStringPatterns() {
    return requestQueryStringPatterns;
  }

  @Override
  ImmutableSet<Pattern> headerPatterns() {
    return headerPatterns;
  }

  @Override
  ImmutableSet<Account.Id> accountIds() {
    return accountIds;
  }

  @Override
  ImmutableSet<Pattern> projectPatterns() {
    return projectPatterns;
  }

  @Override
  public String toString() {
    return "RequestConfig{"
        + "cfg=" + cfg + ", "
        + "section=" + section + ", "
        + "id=" + id + ", "
        + "requestTypes=" + requestTypes + ", "
        + "requestUriPatterns=" + requestUriPatterns + ", "
        + "excludedRequestUriPatterns=" + excludedRequestUriPatterns + ", "
        + "requestQueryStringPatterns=" + requestQueryStringPatterns + ", "
        + "headerPatterns=" + headerPatterns + ", "
        + "accountIds=" + accountIds + ", "
        + "projectPatterns=" + projectPatterns
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RequestConfig) {
      RequestConfig that = (RequestConfig) o;
      return this.cfg.equals(that.cfg())
          && this.section.equals(that.section())
          && this.id.equals(that.id())
          && this.requestTypes.equals(that.requestTypes())
          && this.requestUriPatterns.equals(that.requestUriPatterns())
          && this.excludedRequestUriPatterns.equals(that.excludedRequestUriPatterns())
          && this.requestQueryStringPatterns.equals(that.requestQueryStringPatterns())
          && this.headerPatterns.equals(that.headerPatterns())
          && this.accountIds.equals(that.accountIds())
          && this.projectPatterns.equals(that.projectPatterns());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= cfg.hashCode();
    h$ *= 1000003;
    h$ ^= section.hashCode();
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= requestTypes.hashCode();
    h$ *= 1000003;
    h$ ^= requestUriPatterns.hashCode();
    h$ *= 1000003;
    h$ ^= excludedRequestUriPatterns.hashCode();
    h$ *= 1000003;
    h$ ^= requestQueryStringPatterns.hashCode();
    h$ *= 1000003;
    h$ ^= headerPatterns.hashCode();
    h$ *= 1000003;
    h$ ^= accountIds.hashCode();
    h$ *= 1000003;
    h$ ^= projectPatterns.hashCode();
    return h$;
  }

  static final class Builder extends RequestConfig.Builder {
    private Config cfg;
    private String section;
    private String id;
    private ImmutableSet<String> requestTypes;
    private ImmutableSet<Pattern> requestUriPatterns;
    private ImmutableSet<Pattern> excludedRequestUriPatterns;
    private ImmutableSet<Pattern> requestQueryStringPatterns;
    private ImmutableSet<Pattern> headerPatterns;
    private ImmutableSet<Account.Id> accountIds;
    private ImmutableSet<Pattern> projectPatterns;
    Builder() {
    }
    @Override
    RequestConfig.Builder cfg(Config cfg) {
      if (cfg == null) {
        throw new NullPointerException("Null cfg");
      }
      this.cfg = cfg;
      return this;
    }
    @Override
    RequestConfig.Builder section(String section) {
      if (section == null) {
        throw new NullPointerException("Null section");
      }
      this.section = section;
      return this;
    }
    @Override
    RequestConfig.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    RequestConfig.Builder requestTypes(ImmutableSet<String> requestTypes) {
      if (requestTypes == null) {
        throw new NullPointerException("Null requestTypes");
      }
      this.requestTypes = requestTypes;
      return this;
    }
    @Override
    RequestConfig.Builder requestUriPatterns(ImmutableSet<Pattern> requestUriPatterns) {
      if (requestUriPatterns == null) {
        throw new NullPointerException("Null requestUriPatterns");
      }
      this.requestUriPatterns = requestUriPatterns;
      return this;
    }
    @Override
    RequestConfig.Builder excludedRequestUriPatterns(ImmutableSet<Pattern> excludedRequestUriPatterns) {
      if (excludedRequestUriPatterns == null) {
        throw new NullPointerException("Null excludedRequestUriPatterns");
      }
      this.excludedRequestUriPatterns = excludedRequestUriPatterns;
      return this;
    }
    @Override
    RequestConfig.Builder requestQueryStringPatterns(ImmutableSet<Pattern> requestQueryStringPatterns) {
      if (requestQueryStringPatterns == null) {
        throw new NullPointerException("Null requestQueryStringPatterns");
      }
      this.requestQueryStringPatterns = requestQueryStringPatterns;
      return this;
    }
    @Override
    RequestConfig.Builder headerPatterns(ImmutableSet<Pattern> headerPatterns) {
      if (headerPatterns == null) {
        throw new NullPointerException("Null headerPatterns");
      }
      this.headerPatterns = headerPatterns;
      return this;
    }
    @Override
    RequestConfig.Builder accountIds(ImmutableSet<Account.Id> accountIds) {
      if (accountIds == null) {
        throw new NullPointerException("Null accountIds");
      }
      this.accountIds = accountIds;
      return this;
    }
    @Override
    RequestConfig.Builder projectPatterns(ImmutableSet<Pattern> projectPatterns) {
      if (projectPatterns == null) {
        throw new NullPointerException("Null projectPatterns");
      }
      this.projectPatterns = projectPatterns;
      return this;
    }
    @Override
    RequestConfig build() {
      String missing = "";
      if (this.cfg == null) {
        missing += " cfg";
      }
      if (this.section == null) {
        missing += " section";
      }
      if (this.id == null) {
        missing += " id";
      }
      if (this.requestTypes == null) {
        missing += " requestTypes";
      }
      if (this.requestUriPatterns == null) {
        missing += " requestUriPatterns";
      }
      if (this.excludedRequestUriPatterns == null) {
        missing += " excludedRequestUriPatterns";
      }
      if (this.requestQueryStringPatterns == null) {
        missing += " requestQueryStringPatterns";
      }
      if (this.headerPatterns == null) {
        missing += " headerPatterns";
      }
      if (this.accountIds == null) {
        missing += " accountIds";
      }
      if (this.projectPatterns == null) {
        missing += " projectPatterns";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RequestConfig(
          this.cfg,
          this.section,
          this.id,
          this.requestTypes,
          this.requestUriPatterns,
          this.excludedRequestUriPatterns,
          this.requestQueryStringPatterns,
          this.headerPatterns,
          this.accountIds,
          this.projectPatterns);
    }
  }

}
