package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.entities.NotifyConfig;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.client.EditPreferencesInfo;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.server.account.externalids.ExternalId;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AccountDelta extends AccountDelta {

  private final Optional<String> fullName;

  private final Optional<String> displayName;

  private final Optional<String> preferredEmail;

  private final Optional<Boolean> active;

  private final Optional<String> status;

  private final ImmutableSet<ExternalId> createdExternalIds;

  private final ImmutableSet<ExternalId> updatedExternalIds;

  private final ImmutableSet<ExternalId> deletedExternalIds;

  private final ImmutableMap<ProjectWatches.ProjectWatchKey, Set<NotifyConfig.NotifyType>> updatedProjectWatches;

  private final ImmutableSet<ProjectWatches.ProjectWatchKey> deletedProjectWatches;

  private final Optional<GeneralPreferencesInfo> generalPreferences;

  private final Optional<DiffPreferencesInfo> diffPreferences;

  private final Optional<EditPreferencesInfo> editPreferences;

  private final Optional<Boolean> shouldDeleteAccount;

  private AutoValue_AccountDelta(
      Optional<String> fullName,
      Optional<String> displayName,
      Optional<String> preferredEmail,
      Optional<Boolean> active,
      Optional<String> status,
      ImmutableSet<ExternalId> createdExternalIds,
      ImmutableSet<ExternalId> updatedExternalIds,
      ImmutableSet<ExternalId> deletedExternalIds,
      ImmutableMap<ProjectWatches.ProjectWatchKey, Set<NotifyConfig.NotifyType>> updatedProjectWatches,
      ImmutableSet<ProjectWatches.ProjectWatchKey> deletedProjectWatches,
      Optional<GeneralPreferencesInfo> generalPreferences,
      Optional<DiffPreferencesInfo> diffPreferences,
      Optional<EditPreferencesInfo> editPreferences,
      Optional<Boolean> shouldDeleteAccount) {
    this.fullName = fullName;
    this.displayName = displayName;
    this.preferredEmail = preferredEmail;
    this.active = active;
    this.status = status;
    this.createdExternalIds = createdExternalIds;
    this.updatedExternalIds = updatedExternalIds;
    this.deletedExternalIds = deletedExternalIds;
    this.updatedProjectWatches = updatedProjectWatches;
    this.deletedProjectWatches = deletedProjectWatches;
    this.generalPreferences = generalPreferences;
    this.diffPreferences = diffPreferences;
    this.editPreferences = editPreferences;
    this.shouldDeleteAccount = shouldDeleteAccount;
  }

  @Override
  public Optional<String> getFullName() {
    return fullName;
  }

  @Override
  public Optional<String> getDisplayName() {
    return displayName;
  }

  @Override
  public Optional<String> getPreferredEmail() {
    return preferredEmail;
  }

  @Override
  public Optional<Boolean> getActive() {
    return active;
  }

  @Override
  public Optional<String> getStatus() {
    return status;
  }

  @Override
  public ImmutableSet<ExternalId> getCreatedExternalIds() {
    return createdExternalIds;
  }

  @Override
  public ImmutableSet<ExternalId> getUpdatedExternalIds() {
    return updatedExternalIds;
  }

  @Override
  public ImmutableSet<ExternalId> getDeletedExternalIds() {
    return deletedExternalIds;
  }

  @Override
  public ImmutableMap<ProjectWatches.ProjectWatchKey, Set<NotifyConfig.NotifyType>> getUpdatedProjectWatches() {
    return updatedProjectWatches;
  }

  @Override
  public ImmutableSet<ProjectWatches.ProjectWatchKey> getDeletedProjectWatches() {
    return deletedProjectWatches;
  }

  @Override
  public Optional<GeneralPreferencesInfo> getGeneralPreferences() {
    return generalPreferences;
  }

  @Override
  public Optional<DiffPreferencesInfo> getDiffPreferences() {
    return diffPreferences;
  }

  @Override
  public Optional<EditPreferencesInfo> getEditPreferences() {
    return editPreferences;
  }

  @Override
  public Optional<Boolean> getShouldDeleteAccount() {
    return shouldDeleteAccount;
  }

  @Override
  public String toString() {
    return "AccountDelta{"
        + "fullName=" + fullName + ", "
        + "displayName=" + displayName + ", "
        + "preferredEmail=" + preferredEmail + ", "
        + "active=" + active + ", "
        + "status=" + status + ", "
        + "createdExternalIds=" + createdExternalIds + ", "
        + "updatedExternalIds=" + updatedExternalIds + ", "
        + "deletedExternalIds=" + deletedExternalIds + ", "
        + "updatedProjectWatches=" + updatedProjectWatches + ", "
        + "deletedProjectWatches=" + deletedProjectWatches + ", "
        + "generalPreferences=" + generalPreferences + ", "
        + "diffPreferences=" + diffPreferences + ", "
        + "editPreferences=" + editPreferences + ", "
        + "shouldDeleteAccount=" + shouldDeleteAccount
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AccountDelta) {
      AccountDelta that = (AccountDelta) o;
      return this.fullName.equals(that.getFullName())
          && this.displayName.equals(that.getDisplayName())
          && this.preferredEmail.equals(that.getPreferredEmail())
          && this.active.equals(that.getActive())
          && this.status.equals(that.getStatus())
          && this.createdExternalIds.equals(that.getCreatedExternalIds())
          && this.updatedExternalIds.equals(that.getUpdatedExternalIds())
          && this.deletedExternalIds.equals(that.getDeletedExternalIds())
          && this.updatedProjectWatches.equals(that.getUpdatedProjectWatches())
          && this.deletedProjectWatches.equals(that.getDeletedProjectWatches())
          && this.generalPreferences.equals(that.getGeneralPreferences())
          && this.diffPreferences.equals(that.getDiffPreferences())
          && this.editPreferences.equals(that.getEditPreferences())
          && this.shouldDeleteAccount.equals(that.getShouldDeleteAccount());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= fullName.hashCode();
    h$ *= 1000003;
    h$ ^= displayName.hashCode();
    h$ *= 1000003;
    h$ ^= preferredEmail.hashCode();
    h$ *= 1000003;
    h$ ^= active.hashCode();
    h$ *= 1000003;
    h$ ^= status.hashCode();
    h$ *= 1000003;
    h$ ^= createdExternalIds.hashCode();
    h$ *= 1000003;
    h$ ^= updatedExternalIds.hashCode();
    h$ *= 1000003;
    h$ ^= deletedExternalIds.hashCode();
    h$ *= 1000003;
    h$ ^= updatedProjectWatches.hashCode();
    h$ *= 1000003;
    h$ ^= deletedProjectWatches.hashCode();
    h$ *= 1000003;
    h$ ^= generalPreferences.hashCode();
    h$ *= 1000003;
    h$ ^= diffPreferences.hashCode();
    h$ *= 1000003;
    h$ ^= editPreferences.hashCode();
    h$ *= 1000003;
    h$ ^= shouldDeleteAccount.hashCode();
    return h$;
  }

  static final class Builder extends AccountDelta.Builder {
    private Optional<String> fullName = Optional.empty();
    private Optional<String> displayName = Optional.empty();
    private Optional<String> preferredEmail = Optional.empty();
    private Optional<Boolean> active = Optional.empty();
    private Optional<String> status = Optional.empty();
    private ImmutableSet.Builder<ExternalId> createdExternalIdsBuilder$;
    private ImmutableSet<ExternalId> createdExternalIds;
    private ImmutableSet.Builder<ExternalId> updatedExternalIdsBuilder$;
    private ImmutableSet<ExternalId> updatedExternalIds;
    private ImmutableSet.Builder<ExternalId> deletedExternalIdsBuilder$;
    private ImmutableSet<ExternalId> deletedExternalIds;
    private ImmutableMap.Builder<ProjectWatches.ProjectWatchKey, Set<NotifyConfig.NotifyType>> updatedProjectWatchesBuilder$;
    private ImmutableMap<ProjectWatches.ProjectWatchKey, Set<NotifyConfig.NotifyType>> updatedProjectWatches;
    private ImmutableSet.Builder<ProjectWatches.ProjectWatchKey> deletedProjectWatchesBuilder$;
    private ImmutableSet<ProjectWatches.ProjectWatchKey> deletedProjectWatches;
    private Optional<GeneralPreferencesInfo> generalPreferences = Optional.empty();
    private Optional<DiffPreferencesInfo> diffPreferences = Optional.empty();
    private Optional<EditPreferencesInfo> editPreferences = Optional.empty();
    private Optional<Boolean> shouldDeleteAccount = Optional.empty();
    Builder() {
    }
    @Override
    public AccountDelta.Builder setFullName(@Nullable String fullName) {
      this.fullName = Optional.ofNullable(fullName);
      return this;
    }
    @Override
    public AccountDelta.Builder setDisplayName(@Nullable String displayName) {
      this.displayName = Optional.ofNullable(displayName);
      return this;
    }
    @Override
    public AccountDelta.Builder setPreferredEmail(@Nullable String preferredEmail) {
      this.preferredEmail = Optional.ofNullable(preferredEmail);
      return this;
    }
    @Override
    public AccountDelta.Builder setActive(boolean active) {
      this.active = Optional.of(active);
      return this;
    }
    @Override
    public AccountDelta.Builder setStatus(@Nullable String status) {
      this.status = Optional.ofNullable(status);
      return this;
    }
    @Override
    ImmutableSet.Builder<ExternalId> createdExternalIdsBuilder() {
      if (createdExternalIdsBuilder$ == null) {
        createdExternalIdsBuilder$ = ImmutableSet.builder();
      }
      return createdExternalIdsBuilder$;
    }
    @Override
    ImmutableSet.Builder<ExternalId> updatedExternalIdsBuilder() {
      if (updatedExternalIdsBuilder$ == null) {
        updatedExternalIdsBuilder$ = ImmutableSet.builder();
      }
      return updatedExternalIdsBuilder$;
    }
    @Override
    ImmutableSet.Builder<ExternalId> deletedExternalIdsBuilder() {
      if (deletedExternalIdsBuilder$ == null) {
        deletedExternalIdsBuilder$ = ImmutableSet.builder();
      }
      return deletedExternalIdsBuilder$;
    }
    @Override
    ImmutableMap.Builder<ProjectWatches.ProjectWatchKey, Set<NotifyConfig.NotifyType>> updatedProjectWatchesBuilder() {
      if (updatedProjectWatchesBuilder$ == null) {
        updatedProjectWatchesBuilder$ = ImmutableMap.builder();
      }
      return updatedProjectWatchesBuilder$;
    }
    @Override
    ImmutableSet.Builder<ProjectWatches.ProjectWatchKey> deletedProjectWatchesBuilder() {
      if (deletedProjectWatchesBuilder$ == null) {
        deletedProjectWatchesBuilder$ = ImmutableSet.builder();
      }
      return deletedProjectWatchesBuilder$;
    }
    @Override
    public AccountDelta.Builder setGeneralPreferences(GeneralPreferencesInfo generalPreferences) {
      this.generalPreferences = Optional.of(generalPreferences);
      return this;
    }
    @Override
    public AccountDelta.Builder setDiffPreferences(DiffPreferencesInfo diffPreferences) {
      this.diffPreferences = Optional.of(diffPreferences);
      return this;
    }
    @Override
    public AccountDelta.Builder setEditPreferences(EditPreferencesInfo editPreferences) {
      this.editPreferences = Optional.of(editPreferences);
      return this;
    }
    @Override
    public AccountDelta.Builder setShouldDeleteAccount(boolean shouldDeleteAccount) {
      this.shouldDeleteAccount = Optional.of(shouldDeleteAccount);
      return this;
    }
    @Override
    public AccountDelta build() {
      if (createdExternalIdsBuilder$ != null) {
        this.createdExternalIds = createdExternalIdsBuilder$.build();
      } else if (this.createdExternalIds == null) {
        this.createdExternalIds = ImmutableSet.of();
      }
      if (updatedExternalIdsBuilder$ != null) {
        this.updatedExternalIds = updatedExternalIdsBuilder$.build();
      } else if (this.updatedExternalIds == null) {
        this.updatedExternalIds = ImmutableSet.of();
      }
      if (deletedExternalIdsBuilder$ != null) {
        this.deletedExternalIds = deletedExternalIdsBuilder$.build();
      } else if (this.deletedExternalIds == null) {
        this.deletedExternalIds = ImmutableSet.of();
      }
      if (updatedProjectWatchesBuilder$ != null) {
        this.updatedProjectWatches = updatedProjectWatchesBuilder$.build();
      } else if (this.updatedProjectWatches == null) {
        this.updatedProjectWatches = ImmutableMap.of();
      }
      if (deletedProjectWatchesBuilder$ != null) {
        this.deletedProjectWatches = deletedProjectWatchesBuilder$.build();
      } else if (this.deletedProjectWatches == null) {
        this.deletedProjectWatches = ImmutableSet.of();
      }
      return new AutoValue_AccountDelta(
          this.fullName,
          this.displayName,
          this.preferredEmail,
          this.active,
          this.status,
          this.createdExternalIds,
          this.updatedExternalIds,
          this.deletedExternalIds,
          this.updatedProjectWatches,
          this.deletedProjectWatches,
          this.generalPreferences,
          this.diffPreferences,
          this.editPreferences,
          this.shouldDeleteAccount);
    }
  }

}
