package com.google.gerrit.server.account;

import com.google.gerrit.entities.Account;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AccountSshKey extends AccountSshKey {

  private final Account.Id accountId;

  private final int seq;

  private final String sshPublicKey;

  private final boolean valid;

  private AutoValue_AccountSshKey(
      Account.Id accountId,
      int seq,
      String sshPublicKey,
      boolean valid) {
    this.accountId = accountId;
    this.seq = seq;
    this.sshPublicKey = sshPublicKey;
    this.valid = valid;
  }

  @Override
  public Account.Id accountId() {
    return accountId;
  }

  @Override
  public int seq() {
    return seq;
  }

  @Override
  public String sshPublicKey() {
    return sshPublicKey;
  }

  @Override
  public boolean valid() {
    return valid;
  }

  @Override
  public String toString() {
    return "AccountSshKey{"
        + "accountId=" + accountId + ", "
        + "seq=" + seq + ", "
        + "sshPublicKey=" + sshPublicKey + ", "
        + "valid=" + valid
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AccountSshKey) {
      AccountSshKey that = (AccountSshKey) o;
      return this.accountId.equals(that.accountId())
          && this.seq == that.seq()
          && this.sshPublicKey.equals(that.sshPublicKey())
          && this.valid == that.valid();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= accountId.hashCode();
    h$ *= 1000003;
    h$ ^= seq;
    h$ *= 1000003;
    h$ ^= sshPublicKey.hashCode();
    h$ *= 1000003;
    h$ ^= valid ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends AccountSshKey.Builder {
    private Account.Id accountId;
    private Integer seq;
    private String sshPublicKey;
    private Boolean valid;
    Builder() {
    }
    @Override
    public AccountSshKey.Builder setAccountId(Account.Id accountId) {
      if (accountId == null) {
        throw new NullPointerException("Null accountId");
      }
      this.accountId = accountId;
      return this;
    }
    @Override
    public AccountSshKey.Builder setSeq(int seq) {
      this.seq = seq;
      return this;
    }
    @Override
    public AccountSshKey.Builder setSshPublicKey(String sshPublicKey) {
      if (sshPublicKey == null) {
        throw new NullPointerException("Null sshPublicKey");
      }
      this.sshPublicKey = sshPublicKey;
      return this;
    }
    @Override
    public AccountSshKey.Builder setValid(boolean valid) {
      this.valid = valid;
      return this;
    }
    @Override
    public AccountSshKey build() {
      String missing = "";
      if (this.accountId == null) {
        missing += " accountId";
      }
      if (this.seq == null) {
        missing += " seq";
      }
      if (this.sshPublicKey == null) {
        missing += " sshPublicKey";
      }
      if (this.valid == null) {
        missing += " valid";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AccountSshKey(
          this.accountId,
          this.seq,
          this.sshPublicKey,
          this.valid);
    }
  }

}
