package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.NotifyConfig;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.config.CachedPreferences;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AccountState extends AccountState {

  private final Account account;

  private final ImmutableSet<ExternalId> externalIds;

  private final Optional<String> userName;

  private final ImmutableMap<ProjectWatches.ProjectWatchKey, ImmutableSet<NotifyConfig.NotifyType>> projectWatches;

  private final Optional<CachedPreferences> defaultPreferences;

  private final Optional<CachedPreferences> userPreferences;

  AutoValue_AccountState(
      Account account,
      ImmutableSet<ExternalId> externalIds,
      Optional<String> userName,
      ImmutableMap<ProjectWatches.ProjectWatchKey, ImmutableSet<NotifyConfig.NotifyType>> projectWatches,
      Optional<CachedPreferences> defaultPreferences,
      Optional<CachedPreferences> userPreferences) {
    if (account == null) {
      throw new NullPointerException("Null account");
    }
    this.account = account;
    if (externalIds == null) {
      throw new NullPointerException("Null externalIds");
    }
    this.externalIds = externalIds;
    if (userName == null) {
      throw new NullPointerException("Null userName");
    }
    this.userName = userName;
    if (projectWatches == null) {
      throw new NullPointerException("Null projectWatches");
    }
    this.projectWatches = projectWatches;
    if (defaultPreferences == null) {
      throw new NullPointerException("Null defaultPreferences");
    }
    this.defaultPreferences = defaultPreferences;
    if (userPreferences == null) {
      throw new NullPointerException("Null userPreferences");
    }
    this.userPreferences = userPreferences;
  }

  @Override
  public Account account() {
    return account;
  }

  @Override
  public ImmutableSet<ExternalId> externalIds() {
    return externalIds;
  }

  @Override
  public Optional<String> userName() {
    return userName;
  }

  @Override
  public ImmutableMap<ProjectWatches.ProjectWatchKey, ImmutableSet<NotifyConfig.NotifyType>> projectWatches() {
    return projectWatches;
  }

  @Override
  public Optional<CachedPreferences> defaultPreferences() {
    return defaultPreferences;
  }

  @Override
  public Optional<CachedPreferences> userPreferences() {
    return userPreferences;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AccountState) {
      AccountState that = (AccountState) o;
      return this.account.equals(that.account())
          && this.externalIds.equals(that.externalIds())
          && this.userName.equals(that.userName())
          && this.projectWatches.equals(that.projectWatches())
          && this.defaultPreferences.equals(that.defaultPreferences())
          && this.userPreferences.equals(that.userPreferences());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= account.hashCode();
    h$ *= 1000003;
    h$ ^= externalIds.hashCode();
    h$ *= 1000003;
    h$ ^= userName.hashCode();
    h$ *= 1000003;
    h$ ^= projectWatches.hashCode();
    h$ *= 1000003;
    h$ ^= defaultPreferences.hashCode();
    h$ *= 1000003;
    h$ ^= userPreferences.hashCode();
    return h$;
  }

}
