package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.NotifyConfig;
import com.google.gerrit.server.config.CachedPreferences;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CachedAccountDetails extends CachedAccountDetails {

  private final Account account;

  private final ImmutableMap<ProjectWatches.ProjectWatchKey, ImmutableSet<NotifyConfig.NotifyType>> projectWatches;

  private final CachedPreferences preferences;

  AutoValue_CachedAccountDetails(
      Account account,
      ImmutableMap<ProjectWatches.ProjectWatchKey, ImmutableSet<NotifyConfig.NotifyType>> projectWatches,
      CachedPreferences preferences) {
    if (account == null) {
      throw new NullPointerException("Null account");
    }
    this.account = account;
    if (projectWatches == null) {
      throw new NullPointerException("Null projectWatches");
    }
    this.projectWatches = projectWatches;
    if (preferences == null) {
      throw new NullPointerException("Null preferences");
    }
    this.preferences = preferences;
  }

  @Override
  public Account account() {
    return account;
  }

  @Override
  public ImmutableMap<ProjectWatches.ProjectWatchKey, ImmutableSet<NotifyConfig.NotifyType>> projectWatches() {
    return projectWatches;
  }

  @Override
  public CachedPreferences preferences() {
    return preferences;
  }

  @Override
  public String toString() {
    return "CachedAccountDetails{"
        + "account=" + account + ", "
        + "projectWatches=" + projectWatches + ", "
        + "preferences=" + preferences
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CachedAccountDetails) {
      CachedAccountDetails that = (CachedAccountDetails) o;
      return this.account.equals(that.account())
          && this.projectWatches.equals(that.projectWatches())
          && this.preferences.equals(that.preferences());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= account.hashCode();
    h$ *= 1000003;
    h$ ^= projectWatches.hashCode();
    h$ *= 1000003;
    h$ ^= preferences.hashCode();
    return h$;
  }

}
