package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableList;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.Ref;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GroupsSnapshotReader_Snapshot extends GroupsSnapshotReader.Snapshot {

  private final String hash;

  private final ImmutableList<Ref> groupsRefs;

  AutoValue_GroupsSnapshotReader_Snapshot(
      String hash,
      ImmutableList<Ref> groupsRefs) {
    if (hash == null) {
      throw new NullPointerException("Null hash");
    }
    this.hash = hash;
    if (groupsRefs == null) {
      throw new NullPointerException("Null groupsRefs");
    }
    this.groupsRefs = groupsRefs;
  }

  @Override
  public String hash() {
    return hash;
  }

  @Override
  public ImmutableList<Ref> groupsRefs() {
    return groupsRefs;
  }

  @Override
  public String toString() {
    return "Snapshot{"
        + "hash=" + hash + ", "
        + "groupsRefs=" + groupsRefs
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GroupsSnapshotReader.Snapshot) {
      GroupsSnapshotReader.Snapshot that = (GroupsSnapshotReader.Snapshot) o;
      return this.hash.equals(that.hash())
          && this.groupsRefs.equals(that.groupsRefs());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= hash.hashCode();
    h$ *= 1000003;
    h$ ^= groupsRefs.hashCode();
    return h$;
  }

}
