package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.entities.Comment;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CommentThread<T extends Comment> extends CommentThread<T> {

  private final ImmutableList<T> comments;

  private AutoValue_CommentThread(
      ImmutableList<T> comments) {
    this.comments = comments;
  }

  @Override
  public ImmutableList<T> comments() {
    return comments;
  }

  @Override
  public String toString() {
    return "CommentThread{"
        + "comments=" + comments
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CommentThread) {
      CommentThread<?> that = (CommentThread<?>) o;
      return this.comments.equals(that.comments());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= comments.hashCode();
    return h$;
  }

  static final class Builder<T extends Comment> extends CommentThread.Builder<T> {
    private ImmutableList.Builder<T> commentsBuilder$;
    private ImmutableList<T> comments;
    Builder() {
    }
    @Override
    public CommentThread.Builder<T> comments(List<T> comments) {
      if (commentsBuilder$ != null) {
        throw new IllegalStateException("Cannot set comments after calling commentsBuilder()");
      }
      this.comments = ImmutableList.copyOf(comments);
      return this;
    }
    @Override
    ImmutableList.Builder<T> commentsBuilder() {
      if (commentsBuilder$ == null) {
        if (comments == null) {
          commentsBuilder$ = ImmutableList.builder();
        } else {
          commentsBuilder$ = ImmutableList.builder();
          commentsBuilder$.addAll(comments);
          comments = null;
        }
      }
      return commentsBuilder$;
    }
    @Override
    ImmutableList<T> comments() {
      if (commentsBuilder$ != null) {
        return commentsBuilder$.build();
      }
      if (comments == null) {
        comments = ImmutableList.of();
      }
      return comments;
    }
    @Override
    CommentThread<T> autoBuild() {
      if (commentsBuilder$ != null) {
        this.comments = commentsBuilder$.build();
      } else if (this.comments == null) {
        this.comments = ImmutableList.of();
      }
      return new AutoValue_CommentThread<T>(
          this.comments);
    }
  }

}
