package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.Address;
import com.google.gerrit.entities.PatchSetApproval;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ReviewerOp_Result extends ReviewerOp.Result {

  private final ImmutableList<PatchSetApproval> addedReviewers;

  private final ImmutableList<Address> addedReviewersByEmail;

  private final ImmutableList<Account.Id> addedCCs;

  private final ImmutableList<Address> addedCCsByEmail;

  private final Optional<Account.Id> deletedReviewer;

  private final Optional<Address> deletedReviewerByEmail;

  private AutoValue_ReviewerOp_Result(
      ImmutableList<PatchSetApproval> addedReviewers,
      ImmutableList<Address> addedReviewersByEmail,
      ImmutableList<Account.Id> addedCCs,
      ImmutableList<Address> addedCCsByEmail,
      Optional<Account.Id> deletedReviewer,
      Optional<Address> deletedReviewerByEmail) {
    this.addedReviewers = addedReviewers;
    this.addedReviewersByEmail = addedReviewersByEmail;
    this.addedCCs = addedCCs;
    this.addedCCsByEmail = addedCCsByEmail;
    this.deletedReviewer = deletedReviewer;
    this.deletedReviewerByEmail = deletedReviewerByEmail;
  }

  @Override
  public ImmutableList<PatchSetApproval> addedReviewers() {
    return addedReviewers;
  }

  @Override
  public ImmutableList<Address> addedReviewersByEmail() {
    return addedReviewersByEmail;
  }

  @Override
  public ImmutableList<Account.Id> addedCCs() {
    return addedCCs;
  }

  @Override
  public ImmutableList<Address> addedCCsByEmail() {
    return addedCCsByEmail;
  }

  @Override
  public Optional<Account.Id> deletedReviewer() {
    return deletedReviewer;
  }

  @Override
  public Optional<Address> deletedReviewerByEmail() {
    return deletedReviewerByEmail;
  }

  @Override
  public String toString() {
    return "Result{"
        + "addedReviewers=" + addedReviewers + ", "
        + "addedReviewersByEmail=" + addedReviewersByEmail + ", "
        + "addedCCs=" + addedCCs + ", "
        + "addedCCsByEmail=" + addedCCsByEmail + ", "
        + "deletedReviewer=" + deletedReviewer + ", "
        + "deletedReviewerByEmail=" + deletedReviewerByEmail
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ReviewerOp.Result) {
      ReviewerOp.Result that = (ReviewerOp.Result) o;
      return this.addedReviewers.equals(that.addedReviewers())
          && this.addedReviewersByEmail.equals(that.addedReviewersByEmail())
          && this.addedCCs.equals(that.addedCCs())
          && this.addedCCsByEmail.equals(that.addedCCsByEmail())
          && this.deletedReviewer.equals(that.deletedReviewer())
          && this.deletedReviewerByEmail.equals(that.deletedReviewerByEmail());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= addedReviewers.hashCode();
    h$ *= 1000003;
    h$ ^= addedReviewersByEmail.hashCode();
    h$ *= 1000003;
    h$ ^= addedCCs.hashCode();
    h$ *= 1000003;
    h$ ^= addedCCsByEmail.hashCode();
    h$ *= 1000003;
    h$ ^= deletedReviewer.hashCode();
    h$ *= 1000003;
    h$ ^= deletedReviewerByEmail.hashCode();
    return h$;
  }

  static final class Builder extends ReviewerOp.Result.Builder {
    private ImmutableList<PatchSetApproval> addedReviewers;
    private ImmutableList<Address> addedReviewersByEmail;
    private ImmutableList<Account.Id> addedCCs;
    private ImmutableList<Address> addedCCsByEmail;
    private Optional<Account.Id> deletedReviewer = Optional.empty();
    private Optional<Address> deletedReviewerByEmail = Optional.empty();
    Builder() {
    }
    @Override
    ReviewerOp.Result.Builder setAddedReviewers(Iterable<PatchSetApproval> addedReviewers) {
      this.addedReviewers = ImmutableList.copyOf(addedReviewers);
      return this;
    }
    @Override
    ReviewerOp.Result.Builder setAddedReviewersByEmail(Iterable<Address> addedReviewersByEmail) {
      this.addedReviewersByEmail = ImmutableList.copyOf(addedReviewersByEmail);
      return this;
    }
    @Override
    ReviewerOp.Result.Builder setAddedCCs(Iterable<Account.Id> addedCCs) {
      this.addedCCs = ImmutableList.copyOf(addedCCs);
      return this;
    }
    @Override
    ReviewerOp.Result.Builder setAddedCCsByEmail(Iterable<Address> addedCCsByEmail) {
      this.addedCCsByEmail = ImmutableList.copyOf(addedCCsByEmail);
      return this;
    }
    @Override
    ReviewerOp.Result.Builder setDeletedReviewer(Account.Id deletedReviewer) {
      this.deletedReviewer = Optional.of(deletedReviewer);
      return this;
    }
    @Override
    ReviewerOp.Result.Builder setDeletedReviewerByEmail(Address deletedReviewerByEmail) {
      this.deletedReviewerByEmail = Optional.of(deletedReviewerByEmail);
      return this;
    }
    @Override
    ReviewerOp.Result build() {
      String missing = "";
      if (this.addedReviewers == null) {
        missing += " addedReviewers";
      }
      if (this.addedReviewersByEmail == null) {
        missing += " addedReviewersByEmail";
      }
      if (this.addedCCs == null) {
        missing += " addedCCs";
      }
      if (this.addedCCsByEmail == null) {
        missing += " addedCCsByEmail";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ReviewerOp_Result(
          this.addedReviewers,
          this.addedReviewersByEmail,
          this.addedCCs,
          this.addedCCsByEmail,
          this.deletedReviewer,
          this.deletedReviewerByEmail);
    }
  }

}
