// Copyright (C) 2017 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.gerrit.server.change;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import java.util.Queue;

/**
 * Subclass of {@link SubmitInput} with special bits that may be flipped for testing purposes only.
 */
@VisibleForTesting
public class TestSubmitInput extends SubmitInput {
  public boolean failAfterRefUpdates;

  /**
   * For each change being submitted, an element is removed from this queue and, if the value is
   * true, a bogus ref update is added to the batch, in order to generate a lock failure during
   * execution.
   */
  public Queue<Boolean> generateLockFailures;
}
