package com.google.gerrit.server.comment;

import com.google.gerrit.entities.Change;
import com.google.gerrit.entities.Project;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CommentContextKey extends CommentContextKey {

  private final Project.NameKey project;

  private final Change.Id changeId;

  private final String id;

  private final String path;

  private final Integer patchset;

  private final int contextPadding;

  private AutoValue_CommentContextKey(
      Project.NameKey project,
      Change.Id changeId,
      String id,
      String path,
      Integer patchset,
      int contextPadding) {
    this.project = project;
    this.changeId = changeId;
    this.id = id;
    this.path = path;
    this.patchset = patchset;
    this.contextPadding = contextPadding;
  }

  @Override
  Project.NameKey project() {
    return project;
  }

  @Override
  Change.Id changeId() {
    return changeId;
  }

  @Override
  String id() {
    return id;
  }

  @Override
  String path() {
    return path;
  }

  @Override
  Integer patchset() {
    return patchset;
  }

  @Override
  int contextPadding() {
    return contextPadding;
  }

  @Override
  public String toString() {
    return "CommentContextKey{"
        + "project=" + project + ", "
        + "changeId=" + changeId + ", "
        + "id=" + id + ", "
        + "path=" + path + ", "
        + "patchset=" + patchset + ", "
        + "contextPadding=" + contextPadding
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CommentContextKey) {
      CommentContextKey that = (CommentContextKey) o;
      return this.project.equals(that.project())
          && this.changeId.equals(that.changeId())
          && this.id.equals(that.id())
          && this.path.equals(that.path())
          && this.patchset.equals(that.patchset())
          && this.contextPadding == that.contextPadding();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= changeId.hashCode();
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= path.hashCode();
    h$ *= 1000003;
    h$ ^= patchset.hashCode();
    h$ *= 1000003;
    h$ ^= contextPadding;
    return h$;
  }

  @Override
  CommentContextKey.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends CommentContextKey.Builder {
    private Project.NameKey project;
    private Change.Id changeId;
    private String id;
    private String path;
    private Integer patchset;
    private Integer contextPadding;
    Builder() {
    }
    private Builder(CommentContextKey source) {
      this.project = source.project();
      this.changeId = source.changeId();
      this.id = source.id();
      this.path = source.path();
      this.patchset = source.patchset();
      this.contextPadding = source.contextPadding();
    }
    @Override
    public CommentContextKey.Builder project(Project.NameKey project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    public CommentContextKey.Builder changeId(Change.Id changeId) {
      if (changeId == null) {
        throw new NullPointerException("Null changeId");
      }
      this.changeId = changeId;
      return this;
    }
    @Override
    public CommentContextKey.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public CommentContextKey.Builder path(String path) {
      if (path == null) {
        throw new NullPointerException("Null path");
      }
      this.path = path;
      return this;
    }
    @Override
    public CommentContextKey.Builder patchset(Integer patchset) {
      if (patchset == null) {
        throw new NullPointerException("Null patchset");
      }
      this.patchset = patchset;
      return this;
    }
    @Override
    public CommentContextKey.Builder contextPadding(Integer contextPadding) {
      if (contextPadding == null) {
        throw new NullPointerException("Null contextPadding");
      }
      this.contextPadding = contextPadding;
      return this;
    }
    @Override
    public CommentContextKey build() {
      String missing = "";
      if (this.project == null) {
        missing += " project";
      }
      if (this.changeId == null) {
        missing += " changeId";
      }
      if (this.id == null) {
        missing += " id";
      }
      if (this.path == null) {
        missing += " path";
      }
      if (this.patchset == null) {
        missing += " patchset";
      }
      if (this.contextPadding == null) {
        missing += " contextPadding";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CommentContextKey(
          this.project,
          this.changeId,
          this.id,
          this.path,
          this.patchset,
          this.contextPadding);
    }
  }

}
