package com.google.gerrit.server.comment;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.entities.Comment;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CommentContextLoader_ContextInput extends CommentContextLoader.ContextInput {

  private final ObjectId commitId;

  private final String filePath;

  private final Comment.Range range;

  private final Integer lineNumber;

  private final Integer contextPadding;

  private AutoValue_CommentContextLoader_ContextInput(
      ObjectId commitId,
      String filePath,
      @Nullable Comment.Range range,
      Integer lineNumber,
      Integer contextPadding) {
    this.commitId = commitId;
    this.filePath = filePath;
    this.range = range;
    this.lineNumber = lineNumber;
    this.contextPadding = contextPadding;
  }

  @Override
  ObjectId commitId() {
    return commitId;
  }

  @Override
  String filePath() {
    return filePath;
  }

  @Nullable
  @Override
  Comment.Range range() {
    return range;
  }

  @Override
  Integer lineNumber() {
    return lineNumber;
  }

  @Override
  Integer contextPadding() {
    return contextPadding;
  }

  @Override
  public String toString() {
    return "ContextInput{"
        + "commitId=" + commitId + ", "
        + "filePath=" + filePath + ", "
        + "range=" + range + ", "
        + "lineNumber=" + lineNumber + ", "
        + "contextPadding=" + contextPadding
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CommentContextLoader.ContextInput) {
      CommentContextLoader.ContextInput that = (CommentContextLoader.ContextInput) o;
      return this.commitId.equals(that.commitId())
          && this.filePath.equals(that.filePath())
          && (this.range == null ? that.range() == null : this.range.equals(that.range()))
          && this.lineNumber.equals(that.lineNumber())
          && this.contextPadding.equals(that.contextPadding());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= commitId.hashCode();
    h$ *= 1000003;
    h$ ^= filePath.hashCode();
    h$ *= 1000003;
    h$ ^= (range == null) ? 0 : range.hashCode();
    h$ *= 1000003;
    h$ ^= lineNumber.hashCode();
    h$ *= 1000003;
    h$ ^= contextPadding.hashCode();
    return h$;
  }

  static final class Builder extends CommentContextLoader.ContextInput.Builder {
    private ObjectId commitId;
    private String filePath;
    private Comment.Range range;
    private Integer lineNumber;
    private Integer contextPadding;
    Builder() {
    }
    @Override
    public CommentContextLoader.ContextInput.Builder commitId(ObjectId commitId) {
      if (commitId == null) {
        throw new NullPointerException("Null commitId");
      }
      this.commitId = commitId;
      return this;
    }
    @Override
    public CommentContextLoader.ContextInput.Builder filePath(String filePath) {
      if (filePath == null) {
        throw new NullPointerException("Null filePath");
      }
      this.filePath = filePath;
      return this;
    }
    @Override
    public CommentContextLoader.ContextInput.Builder range(@Nullable Comment.Range range) {
      this.range = range;
      return this;
    }
    @Override
    public CommentContextLoader.ContextInput.Builder lineNumber(Integer lineNumber) {
      if (lineNumber == null) {
        throw new NullPointerException("Null lineNumber");
      }
      this.lineNumber = lineNumber;
      return this;
    }
    @Override
    public CommentContextLoader.ContextInput.Builder contextPadding(Integer contextPadding) {
      if (contextPadding == null) {
        throw new NullPointerException("Null contextPadding");
      }
      this.contextPadding = contextPadding;
      return this;
    }
    @Override
    public CommentContextLoader.ContextInput build() {
      String missing = "";
      if (this.commitId == null) {
        missing += " commitId";
      }
      if (this.filePath == null) {
        missing += " filePath";
      }
      if (this.lineNumber == null) {
        missing += " lineNumber";
      }
      if (this.contextPadding == null) {
        missing += " contextPadding";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CommentContextLoader_ContextInput(
          this.commitId,
          this.filePath,
          this.range,
          this.lineNumber,
          this.contextPadding);
    }
  }

}
