package com.google.gerrit.server.config;

import com.google.gerrit.common.Nullable;
import java.time.ZonedDateTime;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.Config;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_ScheduleConfig extends ScheduleConfig {

  private final Config config;

  private final String section;

  private final String subsection;

  private final String keyInterval;

  private final String keyStartTime;

  private final ZonedDateTime now;

  $AutoValue_ScheduleConfig(
      Config config,
      String section,
      @Nullable String subsection,
      String keyInterval,
      String keyStartTime,
      ZonedDateTime now) {
    if (config == null) {
      throw new NullPointerException("Null config");
    }
    this.config = config;
    if (section == null) {
      throw new NullPointerException("Null section");
    }
    this.section = section;
    this.subsection = subsection;
    if (keyInterval == null) {
      throw new NullPointerException("Null keyInterval");
    }
    this.keyInterval = keyInterval;
    if (keyStartTime == null) {
      throw new NullPointerException("Null keyStartTime");
    }
    this.keyStartTime = keyStartTime;
    if (now == null) {
      throw new NullPointerException("Null now");
    }
    this.now = now;
  }

  @Override
  Config config() {
    return config;
  }

  @Override
  String section() {
    return section;
  }

  @Nullable
  @Override
  String subsection() {
    return subsection;
  }

  @Override
  String keyInterval() {
    return keyInterval;
  }

  @Override
  String keyStartTime() {
    return keyStartTime;
  }

  @Override
  ZonedDateTime now() {
    return now;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ScheduleConfig) {
      ScheduleConfig that = (ScheduleConfig) o;
      return this.config.equals(that.config())
          && this.section.equals(that.section())
          && (this.subsection == null ? that.subsection() == null : this.subsection.equals(that.subsection()))
          && this.keyInterval.equals(that.keyInterval())
          && this.keyStartTime.equals(that.keyStartTime())
          && this.now.equals(that.now());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= config.hashCode();
    h$ *= 1000003;
    h$ ^= section.hashCode();
    h$ *= 1000003;
    h$ ^= (subsection == null) ? 0 : subsection.hashCode();
    h$ *= 1000003;
    h$ ^= keyInterval.hashCode();
    h$ *= 1000003;
    h$ ^= keyStartTime.hashCode();
    h$ *= 1000003;
    h$ ^= now.hashCode();
    return h$;
  }

  static class Builder extends ScheduleConfig.Builder {
    private Config config;
    private String section;
    private String subsection;
    private String keyInterval;
    private String keyStartTime;
    private ZonedDateTime now;
    Builder() {
    }
    @Override
    public ScheduleConfig.Builder setConfig(Config config) {
      if (config == null) {
        throw new NullPointerException("Null config");
      }
      this.config = config;
      return this;
    }
    @Override
    public ScheduleConfig.Builder setSection(String section) {
      if (section == null) {
        throw new NullPointerException("Null section");
      }
      this.section = section;
      return this;
    }
    @Override
    public ScheduleConfig.Builder setSubsection(@Nullable String subsection) {
      this.subsection = subsection;
      return this;
    }
    @Override
    public ScheduleConfig.Builder setKeyInterval(String keyInterval) {
      if (keyInterval == null) {
        throw new NullPointerException("Null keyInterval");
      }
      this.keyInterval = keyInterval;
      return this;
    }
    @Override
    public ScheduleConfig.Builder setKeyStartTime(String keyStartTime) {
      if (keyStartTime == null) {
        throw new NullPointerException("Null keyStartTime");
      }
      this.keyStartTime = keyStartTime;
      return this;
    }
    @Override
    ScheduleConfig.Builder setNow(ZonedDateTime now) {
      if (now == null) {
        throw new NullPointerException("Null now");
      }
      this.now = now;
      return this;
    }
    @Override
    ScheduleConfig build() {
      String missing = "";
      if (this.config == null) {
        missing += " config";
      }
      if (this.section == null) {
        missing += " section";
      }
      if (this.keyInterval == null) {
        missing += " keyInterval";
      }
      if (this.keyStartTime == null) {
        missing += " keyStartTime";
      }
      if (this.now == null) {
        missing += " now";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ScheduleConfig(
          this.config,
          this.section,
          this.subsection,
          this.keyInterval,
          this.keyStartTime,
          this.now);
    }
  }

}
