package com.google.gerrit.server.git;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.entities.Change;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ChangeReportFormatter_Input extends ChangeReportFormatter.Input {

  private final Change change;

  private final String subject;

  private final Boolean isEdit;

  private final Boolean isPrivate;

  private final Boolean isWorkInProgress;

  private AutoValue_ChangeReportFormatter_Input(
      Change change,
      @Nullable String subject,
      @Nullable Boolean isEdit,
      @Nullable Boolean isPrivate,
      @Nullable Boolean isWorkInProgress) {
    this.change = change;
    this.subject = subject;
    this.isEdit = isEdit;
    this.isPrivate = isPrivate;
    this.isWorkInProgress = isWorkInProgress;
  }

  @Override
  public Change change() {
    return change;
  }

  @Nullable
  @Override
  public String subject() {
    return subject;
  }

  @Nullable
  @Override
  public Boolean isEdit() {
    return isEdit;
  }

  @Nullable
  @Override
  public Boolean isPrivate() {
    return isPrivate;
  }

  @Nullable
  @Override
  public Boolean isWorkInProgress() {
    return isWorkInProgress;
  }

  @Override
  public String toString() {
    return "Input{"
        + "change=" + change + ", "
        + "subject=" + subject + ", "
        + "isEdit=" + isEdit + ", "
        + "isPrivate=" + isPrivate + ", "
        + "isWorkInProgress=" + isWorkInProgress
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ChangeReportFormatter.Input) {
      ChangeReportFormatter.Input that = (ChangeReportFormatter.Input) o;
      return this.change.equals(that.change())
          && (this.subject == null ? that.subject() == null : this.subject.equals(that.subject()))
          && (this.isEdit == null ? that.isEdit() == null : this.isEdit.equals(that.isEdit()))
          && (this.isPrivate == null ? that.isPrivate() == null : this.isPrivate.equals(that.isPrivate()))
          && (this.isWorkInProgress == null ? that.isWorkInProgress() == null : this.isWorkInProgress.equals(that.isWorkInProgress()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= change.hashCode();
    h$ *= 1000003;
    h$ ^= (subject == null) ? 0 : subject.hashCode();
    h$ *= 1000003;
    h$ ^= (isEdit == null) ? 0 : isEdit.hashCode();
    h$ *= 1000003;
    h$ ^= (isPrivate == null) ? 0 : isPrivate.hashCode();
    h$ *= 1000003;
    h$ ^= (isWorkInProgress == null) ? 0 : isWorkInProgress.hashCode();
    return h$;
  }

  static final class Builder extends ChangeReportFormatter.Input.Builder {
    private Change change;
    private String subject;
    private Boolean isEdit;
    private Boolean isPrivate;
    private Boolean isWorkInProgress;
    Builder() {
    }
    @Override
    public ChangeReportFormatter.Input.Builder setChange(Change change) {
      if (change == null) {
        throw new NullPointerException("Null change");
      }
      this.change = change;
      return this;
    }
    @Override
    Change change() {
      if (change == null) {
        throw new IllegalStateException("Property \"change\" has not been set");
      }
      return change;
    }
    @Override
    public ChangeReportFormatter.Input.Builder setSubject(String subject) {
      this.subject = subject;
      return this;
    }
    @Override
    @Nullable String subject() {
      return subject;
    }
    @Override
    public ChangeReportFormatter.Input.Builder setIsEdit(Boolean isEdit) {
      this.isEdit = isEdit;
      return this;
    }
    @Override
    @Nullable Boolean isEdit() {
      return isEdit;
    }
    @Override
    public ChangeReportFormatter.Input.Builder setIsPrivate(Boolean isPrivate) {
      this.isPrivate = isPrivate;
      return this;
    }
    @Override
    @Nullable Boolean isPrivate() {
      return isPrivate;
    }
    @Override
    public ChangeReportFormatter.Input.Builder setIsWorkInProgress(Boolean isWorkInProgress) {
      this.isWorkInProgress = isWorkInProgress;
      return this;
    }
    @Override
    @Nullable Boolean isWorkInProgress() {
      return isWorkInProgress;
    }
    @Override
    ChangeReportFormatter.Input autoBuild() {
      String missing = "";
      if (this.change == null) {
        missing += " change";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ChangeReportFormatter_Input(
          this.change,
          this.subject,
          this.isEdit,
          this.isPrivate,
          this.isWorkInProgress);
    }
  }

}
