package com.google.gerrit.server.git;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.approval.ApprovalsUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.UrlFormatter;
import com.google.gerrit.server.project.ProjectState;
import javax.annotation.processing.Generated;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.jgit.lib.Config;

@Generated(
    value = "com.google.auto.factory.processor.AutoFactoryProcessor",
    comments = "https://github.com/google/auto/tree/master/factory"
)
public final class MergeUtilFactory {
  private final Provider<Config> serverConfigProvider;

  private final Provider<IdentifiedUser.GenericFactory> identifiedUserFactoryProvider;

  private final Provider<DynamicItem<UrlFormatter>> urlFormatterProvider;

  private final Provider<ApprovalsUtil> approvalsUtilProvider;

  private final Provider<PluggableCommitMessageGenerator> commitMessageGeneratorProvider;

  private final Provider<ChangeUtil> changeUtilProvider;

  @Inject
  public MergeUtilFactory(@GerritServerConfig Provider<Config> serverConfigProvider,
      Provider<IdentifiedUser.GenericFactory> identifiedUserFactoryProvider,
      Provider<DynamicItem<UrlFormatter>> urlFormatterProvider,
      Provider<ApprovalsUtil> approvalsUtilProvider,
      Provider<PluggableCommitMessageGenerator> commitMessageGeneratorProvider,
      Provider<ChangeUtil> changeUtilProvider) {
    this.serverConfigProvider = checkNotNull(serverConfigProvider, 1);
    this.identifiedUserFactoryProvider = checkNotNull(identifiedUserFactoryProvider, 2);
    this.urlFormatterProvider = checkNotNull(urlFormatterProvider, 3);
    this.approvalsUtilProvider = checkNotNull(approvalsUtilProvider, 4);
    this.commitMessageGeneratorProvider = checkNotNull(commitMessageGeneratorProvider, 5);
    this.changeUtilProvider = checkNotNull(changeUtilProvider, 6);
  }

  public MergeUtil create(ProjectState project) {
    return new MergeUtil(checkNotNull(serverConfigProvider.get(), 1), checkNotNull(identifiedUserFactoryProvider.get(), 2), checkNotNull(urlFormatterProvider.get(), 3), checkNotNull(approvalsUtilProvider.get(), 4), checkNotNull(commitMessageGeneratorProvider.get(), 5), checkNotNull(changeUtilProvider.get(), 6), checkNotNull(project, 7));
  }

  public MergeUtil create(ProjectState project, boolean useContentMerge) {
    return new MergeUtil(checkNotNull(serverConfigProvider.get(), 1), checkNotNull(identifiedUserFactoryProvider.get(), 2), checkNotNull(urlFormatterProvider.get(), 3), checkNotNull(approvalsUtilProvider.get(), 4), checkNotNull(commitMessageGeneratorProvider.get(), 5), checkNotNull(changeUtilProvider.get(), 6), checkNotNull(project, 7), useContentMerge);
  }

  private static <T> T checkNotNull(T reference, int argumentIndex) {
    if (reference == null) {
      throw new NullPointerException("@AutoFactory method argument is null but is not marked @Nullable. Argument index: " + argumentIndex);
    }
    return reference;
  }
}
