package com.google.gerrit.server.group.db;

import com.google.gerrit.entities.AccountGroup;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GroupDelta extends GroupDelta {

  private final Optional<AccountGroup.NameKey> name;

  private final Optional<String> description;

  private final Optional<AccountGroup.UUID> ownerGroupUUID;

  private final Optional<Boolean> visibleToAll;

  private final GroupDelta.MemberModification memberModification;

  private final GroupDelta.SubgroupModification subgroupModification;

  private final Optional<Instant> updatedOn;

  private AutoValue_GroupDelta(
      Optional<AccountGroup.NameKey> name,
      Optional<String> description,
      Optional<AccountGroup.UUID> ownerGroupUUID,
      Optional<Boolean> visibleToAll,
      GroupDelta.MemberModification memberModification,
      GroupDelta.SubgroupModification subgroupModification,
      Optional<Instant> updatedOn) {
    this.name = name;
    this.description = description;
    this.ownerGroupUUID = ownerGroupUUID;
    this.visibleToAll = visibleToAll;
    this.memberModification = memberModification;
    this.subgroupModification = subgroupModification;
    this.updatedOn = updatedOn;
  }

  @Override
  public Optional<AccountGroup.NameKey> getName() {
    return name;
  }

  @Override
  public Optional<String> getDescription() {
    return description;
  }

  @Override
  public Optional<AccountGroup.UUID> getOwnerGroupUUID() {
    return ownerGroupUUID;
  }

  @Override
  public Optional<Boolean> getVisibleToAll() {
    return visibleToAll;
  }

  @Override
  public GroupDelta.MemberModification getMemberModification() {
    return memberModification;
  }

  @Override
  public GroupDelta.SubgroupModification getSubgroupModification() {
    return subgroupModification;
  }

  @Override
  public Optional<Instant> getUpdatedOn() {
    return updatedOn;
  }

  @Override
  public String toString() {
    return "GroupDelta{"
        + "name=" + name + ", "
        + "description=" + description + ", "
        + "ownerGroupUUID=" + ownerGroupUUID + ", "
        + "visibleToAll=" + visibleToAll + ", "
        + "memberModification=" + memberModification + ", "
        + "subgroupModification=" + subgroupModification + ", "
        + "updatedOn=" + updatedOn
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GroupDelta) {
      GroupDelta that = (GroupDelta) o;
      return this.name.equals(that.getName())
          && this.description.equals(that.getDescription())
          && this.ownerGroupUUID.equals(that.getOwnerGroupUUID())
          && this.visibleToAll.equals(that.getVisibleToAll())
          && this.memberModification.equals(that.getMemberModification())
          && this.subgroupModification.equals(that.getSubgroupModification())
          && this.updatedOn.equals(that.getUpdatedOn());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= ownerGroupUUID.hashCode();
    h$ *= 1000003;
    h$ ^= visibleToAll.hashCode();
    h$ *= 1000003;
    h$ ^= memberModification.hashCode();
    h$ *= 1000003;
    h$ ^= subgroupModification.hashCode();
    h$ *= 1000003;
    h$ ^= updatedOn.hashCode();
    return h$;
  }

  @Override
  public GroupDelta.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GroupDelta.Builder {
    private Optional<AccountGroup.NameKey> name = Optional.empty();
    private Optional<String> description = Optional.empty();
    private Optional<AccountGroup.UUID> ownerGroupUUID = Optional.empty();
    private Optional<Boolean> visibleToAll = Optional.empty();
    private GroupDelta.MemberModification memberModification;
    private GroupDelta.SubgroupModification subgroupModification;
    private Optional<Instant> updatedOn = Optional.empty();
    Builder() {
    }
    private Builder(GroupDelta source) {
      this.name = source.getName();
      this.description = source.getDescription();
      this.ownerGroupUUID = source.getOwnerGroupUUID();
      this.visibleToAll = source.getVisibleToAll();
      this.memberModification = source.getMemberModification();
      this.subgroupModification = source.getSubgroupModification();
      this.updatedOn = source.getUpdatedOn();
    }
    @Override
    public GroupDelta.Builder setName(AccountGroup.NameKey name) {
      this.name = Optional.of(name);
      return this;
    }
    @Override
    public GroupDelta.Builder setDescription(String description) {
      this.description = Optional.of(description);
      return this;
    }
    @Override
    public GroupDelta.Builder setOwnerGroupUUID(AccountGroup.UUID ownerGroupUUID) {
      this.ownerGroupUUID = Optional.of(ownerGroupUUID);
      return this;
    }
    @Override
    public GroupDelta.Builder setVisibleToAll(boolean visibleToAll) {
      this.visibleToAll = Optional.of(visibleToAll);
      return this;
    }
    @Override
    public GroupDelta.Builder setMemberModification(GroupDelta.MemberModification memberModification) {
      if (memberModification == null) {
        throw new NullPointerException("Null memberModification");
      }
      this.memberModification = memberModification;
      return this;
    }
    @Override
    public GroupDelta.MemberModification getMemberModification() {
      if (memberModification == null) {
        throw new IllegalStateException("Property \"memberModification\" has not been set");
      }
      return memberModification;
    }
    @Override
    public GroupDelta.Builder setSubgroupModification(GroupDelta.SubgroupModification subgroupModification) {
      if (subgroupModification == null) {
        throw new NullPointerException("Null subgroupModification");
      }
      this.subgroupModification = subgroupModification;
      return this;
    }
    @Override
    public GroupDelta.SubgroupModification getSubgroupModification() {
      if (subgroupModification == null) {
        throw new IllegalStateException("Property \"subgroupModification\" has not been set");
      }
      return subgroupModification;
    }
    @Override
    public GroupDelta.Builder setUpdatedOn(Instant updatedOn) {
      this.updatedOn = Optional.of(updatedOn);
      return this;
    }
    @Override
    public GroupDelta build() {
      String missing = "";
      if (this.memberModification == null) {
        missing += " memberModification";
      }
      if (this.subgroupModification == null) {
        missing += " subgroupModification";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GroupDelta(
          this.name,
          this.description,
          this.ownerGroupUUID,
          this.visibleToAll,
          this.memberModification,
          this.subgroupModification,
          this.updatedOn);
    }
  }

}
