package com.google.gerrit.server.group.db;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.AccountGroup;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GroupsUpdate_UpdateResult extends GroupsUpdate.UpdateResult {

  private final AccountGroup.UUID groupUuid;

  private final AccountGroup.Id groupId;

  private final AccountGroup.NameKey groupName;

  private final Optional<AccountGroup.NameKey> previousGroupName;

  private final ImmutableSet<Account.Id> addedMembers;

  private final ImmutableSet<Account.Id> deletedMembers;

  private final ImmutableSet<AccountGroup.UUID> addedSubgroups;

  private final ImmutableSet<AccountGroup.UUID> deletedSubgroups;

  private AutoValue_GroupsUpdate_UpdateResult(
      AccountGroup.UUID groupUuid,
      AccountGroup.Id groupId,
      AccountGroup.NameKey groupName,
      Optional<AccountGroup.NameKey> previousGroupName,
      ImmutableSet<Account.Id> addedMembers,
      ImmutableSet<Account.Id> deletedMembers,
      ImmutableSet<AccountGroup.UUID> addedSubgroups,
      ImmutableSet<AccountGroup.UUID> deletedSubgroups) {
    this.groupUuid = groupUuid;
    this.groupId = groupId;
    this.groupName = groupName;
    this.previousGroupName = previousGroupName;
    this.addedMembers = addedMembers;
    this.deletedMembers = deletedMembers;
    this.addedSubgroups = addedSubgroups;
    this.deletedSubgroups = deletedSubgroups;
  }

  @Override
  AccountGroup.UUID getGroupUuid() {
    return groupUuid;
  }

  @Override
  AccountGroup.Id getGroupId() {
    return groupId;
  }

  @Override
  AccountGroup.NameKey getGroupName() {
    return groupName;
  }

  @Override
  Optional<AccountGroup.NameKey> getPreviousGroupName() {
    return previousGroupName;
  }

  @Override
  ImmutableSet<Account.Id> getAddedMembers() {
    return addedMembers;
  }

  @Override
  ImmutableSet<Account.Id> getDeletedMembers() {
    return deletedMembers;
  }

  @Override
  ImmutableSet<AccountGroup.UUID> getAddedSubgroups() {
    return addedSubgroups;
  }

  @Override
  ImmutableSet<AccountGroup.UUID> getDeletedSubgroups() {
    return deletedSubgroups;
  }

  @Override
  public String toString() {
    return "UpdateResult{"
        + "groupUuid=" + groupUuid + ", "
        + "groupId=" + groupId + ", "
        + "groupName=" + groupName + ", "
        + "previousGroupName=" + previousGroupName + ", "
        + "addedMembers=" + addedMembers + ", "
        + "deletedMembers=" + deletedMembers + ", "
        + "addedSubgroups=" + addedSubgroups + ", "
        + "deletedSubgroups=" + deletedSubgroups
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GroupsUpdate.UpdateResult) {
      GroupsUpdate.UpdateResult that = (GroupsUpdate.UpdateResult) o;
      return this.groupUuid.equals(that.getGroupUuid())
          && this.groupId.equals(that.getGroupId())
          && this.groupName.equals(that.getGroupName())
          && this.previousGroupName.equals(that.getPreviousGroupName())
          && this.addedMembers.equals(that.getAddedMembers())
          && this.deletedMembers.equals(that.getDeletedMembers())
          && this.addedSubgroups.equals(that.getAddedSubgroups())
          && this.deletedSubgroups.equals(that.getDeletedSubgroups());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= groupUuid.hashCode();
    h$ *= 1000003;
    h$ ^= groupId.hashCode();
    h$ *= 1000003;
    h$ ^= groupName.hashCode();
    h$ *= 1000003;
    h$ ^= previousGroupName.hashCode();
    h$ *= 1000003;
    h$ ^= addedMembers.hashCode();
    h$ *= 1000003;
    h$ ^= deletedMembers.hashCode();
    h$ *= 1000003;
    h$ ^= addedSubgroups.hashCode();
    h$ *= 1000003;
    h$ ^= deletedSubgroups.hashCode();
    return h$;
  }

  static final class Builder extends GroupsUpdate.UpdateResult.Builder {
    private AccountGroup.UUID groupUuid;
    private AccountGroup.Id groupId;
    private AccountGroup.NameKey groupName;
    private Optional<AccountGroup.NameKey> previousGroupName = Optional.empty();
    private ImmutableSet<Account.Id> addedMembers;
    private ImmutableSet<Account.Id> deletedMembers;
    private ImmutableSet<AccountGroup.UUID> addedSubgroups;
    private ImmutableSet<AccountGroup.UUID> deletedSubgroups;
    Builder() {
    }
    @Override
    GroupsUpdate.UpdateResult.Builder setGroupUuid(AccountGroup.UUID groupUuid) {
      if (groupUuid == null) {
        throw new NullPointerException("Null groupUuid");
      }
      this.groupUuid = groupUuid;
      return this;
    }
    @Override
    GroupsUpdate.UpdateResult.Builder setGroupId(AccountGroup.Id groupId) {
      if (groupId == null) {
        throw new NullPointerException("Null groupId");
      }
      this.groupId = groupId;
      return this;
    }
    @Override
    GroupsUpdate.UpdateResult.Builder setGroupName(AccountGroup.NameKey groupName) {
      if (groupName == null) {
        throw new NullPointerException("Null groupName");
      }
      this.groupName = groupName;
      return this;
    }
    @Override
    GroupsUpdate.UpdateResult.Builder setPreviousGroupName(AccountGroup.NameKey previousGroupName) {
      this.previousGroupName = Optional.of(previousGroupName);
      return this;
    }
    @Override
    GroupsUpdate.UpdateResult.Builder setAddedMembers(Set<Account.Id> addedMembers) {
      this.addedMembers = ImmutableSet.copyOf(addedMembers);
      return this;
    }
    @Override
    GroupsUpdate.UpdateResult.Builder setDeletedMembers(Set<Account.Id> deletedMembers) {
      this.deletedMembers = ImmutableSet.copyOf(deletedMembers);
      return this;
    }
    @Override
    GroupsUpdate.UpdateResult.Builder setAddedSubgroups(Set<AccountGroup.UUID> addedSubgroups) {
      this.addedSubgroups = ImmutableSet.copyOf(addedSubgroups);
      return this;
    }
    @Override
    GroupsUpdate.UpdateResult.Builder setDeletedSubgroups(Set<AccountGroup.UUID> deletedSubgroups) {
      this.deletedSubgroups = ImmutableSet.copyOf(deletedSubgroups);
      return this;
    }
    @Override
    GroupsUpdate.UpdateResult build() {
      String missing = "";
      if (this.groupUuid == null) {
        missing += " groupUuid";
      }
      if (this.groupId == null) {
        missing += " groupId";
      }
      if (this.groupName == null) {
        missing += " groupName";
      }
      if (this.addedMembers == null) {
        missing += " addedMembers";
      }
      if (this.deletedMembers == null) {
        missing += " deletedMembers";
      }
      if (this.addedSubgroups == null) {
        missing += " addedSubgroups";
      }
      if (this.deletedSubgroups == null) {
        missing += " deletedSubgroups";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GroupsUpdate_UpdateResult(
          this.groupUuid,
          this.groupId,
          this.groupName,
          this.previousGroupName,
          this.addedMembers,
          this.deletedMembers,
          this.addedSubgroups,
          this.deletedSubgroups);
    }
  }

}
